/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.S3ReferenceDataSourceUpdate;
import software.amazon.awssdk.services.kinesisanalytics.model.SourceSchema;
import software.amazon.awssdk.services.kinesisanalytics.transform.ReferenceDataSourceUpdateMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReferenceDataSourceUpdate
implements StructuredPojo,
ToCopyableBuilder<Builder, ReferenceDataSourceUpdate> {
    private final String referenceId;
    private final String tableNameUpdate;
    private final S3ReferenceDataSourceUpdate s3ReferenceDataSourceUpdate;
    private final SourceSchema referenceSchemaUpdate;

    private ReferenceDataSourceUpdate(BuilderImpl builder) {
        this.referenceId = builder.referenceId;
        this.tableNameUpdate = builder.tableNameUpdate;
        this.s3ReferenceDataSourceUpdate = builder.s3ReferenceDataSourceUpdate;
        this.referenceSchemaUpdate = builder.referenceSchemaUpdate;
    }

    public String referenceId() {
        return this.referenceId;
    }

    public String tableNameUpdate() {
        return this.tableNameUpdate;
    }

    public S3ReferenceDataSourceUpdate s3ReferenceDataSourceUpdate() {
        return this.s3ReferenceDataSourceUpdate;
    }

    public SourceSchema referenceSchemaUpdate() {
        return this.referenceSchemaUpdate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.referenceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableNameUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3ReferenceDataSourceUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.referenceSchemaUpdate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferenceDataSourceUpdate)) {
            return false;
        }
        ReferenceDataSourceUpdate other = (ReferenceDataSourceUpdate)obj;
        return Objects.equals(this.referenceId(), other.referenceId()) && Objects.equals(this.tableNameUpdate(), other.tableNameUpdate()) && Objects.equals(this.s3ReferenceDataSourceUpdate(), other.s3ReferenceDataSourceUpdate()) && Objects.equals(this.referenceSchemaUpdate(), other.referenceSchemaUpdate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.referenceId() != null) {
            sb.append("ReferenceId: ").append(this.referenceId()).append(",");
        }
        if (this.tableNameUpdate() != null) {
            sb.append("TableNameUpdate: ").append(this.tableNameUpdate()).append(",");
        }
        if (this.s3ReferenceDataSourceUpdate() != null) {
            sb.append("S3ReferenceDataSourceUpdate: ").append(this.s3ReferenceDataSourceUpdate()).append(",");
        }
        if (this.referenceSchemaUpdate() != null) {
            sb.append("ReferenceSchemaUpdate: ").append(this.referenceSchemaUpdate()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReferenceId": {
                return Optional.of(clazz.cast(this.referenceId()));
            }
            case "TableNameUpdate": {
                return Optional.of(clazz.cast(this.tableNameUpdate()));
            }
            case "S3ReferenceDataSourceUpdate": {
                return Optional.of(clazz.cast(this.s3ReferenceDataSourceUpdate()));
            }
            case "ReferenceSchemaUpdate": {
                return Optional.of(clazz.cast(this.referenceSchemaUpdate()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReferenceDataSourceUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String referenceId;
        private String tableNameUpdate;
        private S3ReferenceDataSourceUpdate s3ReferenceDataSourceUpdate;
        private SourceSchema referenceSchemaUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(ReferenceDataSourceUpdate model) {
            this.referenceId(model.referenceId);
            this.tableNameUpdate(model.tableNameUpdate);
            this.s3ReferenceDataSourceUpdate(model.s3ReferenceDataSourceUpdate);
            this.referenceSchemaUpdate(model.referenceSchemaUpdate);
        }

        public final String getReferenceId() {
            return this.referenceId;
        }

        @Override
        public final Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public final void setReferenceId(String referenceId) {
            this.referenceId = referenceId;
        }

        public final String getTableNameUpdate() {
            return this.tableNameUpdate;
        }

        @Override
        public final Builder tableNameUpdate(String tableNameUpdate) {
            this.tableNameUpdate = tableNameUpdate;
            return this;
        }

        public final void setTableNameUpdate(String tableNameUpdate) {
            this.tableNameUpdate = tableNameUpdate;
        }

        public final S3ReferenceDataSourceUpdate.Builder getS3ReferenceDataSourceUpdate() {
            return this.s3ReferenceDataSourceUpdate != null ? this.s3ReferenceDataSourceUpdate.toBuilder() : null;
        }

        @Override
        public final Builder s3ReferenceDataSourceUpdate(S3ReferenceDataSourceUpdate s3ReferenceDataSourceUpdate) {
            this.s3ReferenceDataSourceUpdate = s3ReferenceDataSourceUpdate;
            return this;
        }

        public final void setS3ReferenceDataSourceUpdate(S3ReferenceDataSourceUpdate.BuilderImpl s3ReferenceDataSourceUpdate) {
            this.s3ReferenceDataSourceUpdate = s3ReferenceDataSourceUpdate != null ? s3ReferenceDataSourceUpdate.build() : null;
        }

        public final SourceSchema.Builder getReferenceSchemaUpdate() {
            return this.referenceSchemaUpdate != null ? this.referenceSchemaUpdate.toBuilder() : null;
        }

        @Override
        public final Builder referenceSchemaUpdate(SourceSchema referenceSchemaUpdate) {
            this.referenceSchemaUpdate = referenceSchemaUpdate;
            return this;
        }

        public final void setReferenceSchemaUpdate(SourceSchema.BuilderImpl referenceSchemaUpdate) {
            this.referenceSchemaUpdate = referenceSchemaUpdate != null ? referenceSchemaUpdate.build() : null;
        }

        public ReferenceDataSourceUpdate build() {
            return new ReferenceDataSourceUpdate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReferenceDataSourceUpdate> {
        public Builder referenceId(String var1);

        public Builder tableNameUpdate(String var1);

        public Builder s3ReferenceDataSourceUpdate(S3ReferenceDataSourceUpdate var1);

        default public Builder s3ReferenceDataSourceUpdate(Consumer<S3ReferenceDataSourceUpdate.Builder> s3ReferenceDataSourceUpdate) {
            return this.s3ReferenceDataSourceUpdate((S3ReferenceDataSourceUpdate)((S3ReferenceDataSourceUpdate.Builder)S3ReferenceDataSourceUpdate.builder().apply(s3ReferenceDataSourceUpdate)).build());
        }

        public Builder referenceSchemaUpdate(SourceSchema var1);

        default public Builder referenceSchemaUpdate(Consumer<SourceSchema.Builder> referenceSchemaUpdate) {
            return this.referenceSchemaUpdate((SourceSchema)((SourceSchema.Builder)SourceSchema.builder().apply(referenceSchemaUpdate)).build());
        }
    }
}

