/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListApplicationsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListApplicationsRequest> {
    private final Integer limit;
    private final String exclusiveStartApplicationName;

    private ListApplicationsRequest(BuilderImpl builder) {
        this.limit = builder.limit;
        this.exclusiveStartApplicationName = builder.exclusiveStartApplicationName;
    }

    public Integer limit() {
        return this.limit;
    }

    public String exclusiveStartApplicationName() {
        return this.exclusiveStartApplicationName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.exclusiveStartApplicationName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationsRequest)) {
            return false;
        }
        ListApplicationsRequest other = (ListApplicationsRequest)((Object)obj);
        return Objects.equals(this.limit(), other.limit()) && Objects.equals(this.exclusiveStartApplicationName(), other.exclusiveStartApplicationName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.limit() != null) {
            sb.append("Limit: ").append(this.limit()).append(",");
        }
        if (this.exclusiveStartApplicationName() != null) {
            sb.append("ExclusiveStartApplicationName: ").append(this.exclusiveStartApplicationName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Limit": {
                return Optional.of(clazz.cast(this.limit()));
            }
            case "ExclusiveStartApplicationName": {
                return Optional.of(clazz.cast(this.exclusiveStartApplicationName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Integer limit;
        private String exclusiveStartApplicationName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationsRequest model) {
            this.limit(model.limit);
            this.exclusiveStartApplicationName(model.exclusiveStartApplicationName);
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getExclusiveStartApplicationName() {
            return this.exclusiveStartApplicationName;
        }

        @Override
        public final Builder exclusiveStartApplicationName(String exclusiveStartApplicationName) {
            this.exclusiveStartApplicationName = exclusiveStartApplicationName;
            return this;
        }

        public final void setExclusiveStartApplicationName(String exclusiveStartApplicationName) {
            this.exclusiveStartApplicationName = exclusiveStartApplicationName;
        }

        public ListApplicationsRequest build() {
            return new ListApplicationsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListApplicationsRequest> {
        public Builder limit(Integer var1);

        public Builder exclusiveStartApplicationName(String var1);
    }
}

