/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.kinesisanalytics.model.InputProcessingConfiguration;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AddApplicationInputProcessingConfigurationRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AddApplicationInputProcessingConfigurationRequest> {
    private final String applicationName;
    private final Long currentApplicationVersionId;
    private final String inputId;
    private final InputProcessingConfiguration inputProcessingConfiguration;

    private AddApplicationInputProcessingConfigurationRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.currentApplicationVersionId = builder.currentApplicationVersionId;
        this.inputId = builder.inputId;
        this.inputProcessingConfiguration = builder.inputProcessingConfiguration;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public Long currentApplicationVersionId() {
        return this.currentApplicationVersionId;
    }

    public String inputId() {
        return this.inputId;
    }

    public InputProcessingConfiguration inputProcessingConfiguration() {
        return this.inputProcessingConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentApplicationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputId());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputProcessingConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddApplicationInputProcessingConfigurationRequest)) {
            return false;
        }
        AddApplicationInputProcessingConfigurationRequest other = (AddApplicationInputProcessingConfigurationRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.currentApplicationVersionId(), other.currentApplicationVersionId()) && Objects.equals(this.inputId(), other.inputId()) && Objects.equals(this.inputProcessingConfiguration(), other.inputProcessingConfiguration());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.currentApplicationVersionId() != null) {
            sb.append("CurrentApplicationVersionId: ").append(this.currentApplicationVersionId()).append(",");
        }
        if (this.inputId() != null) {
            sb.append("InputId: ").append(this.inputId()).append(",");
        }
        if (this.inputProcessingConfiguration() != null) {
            sb.append("InputProcessingConfiguration: ").append(this.inputProcessingConfiguration()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.of(clazz.cast(this.applicationName()));
            }
            case "CurrentApplicationVersionId": {
                return Optional.of(clazz.cast(this.currentApplicationVersionId()));
            }
            case "InputId": {
                return Optional.of(clazz.cast(this.inputId()));
            }
            case "InputProcessingConfiguration": {
                return Optional.of(clazz.cast(this.inputProcessingConfiguration()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private Long currentApplicationVersionId;
        private String inputId;
        private InputProcessingConfiguration inputProcessingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(AddApplicationInputProcessingConfigurationRequest model) {
            this.applicationName(model.applicationName);
            this.currentApplicationVersionId(model.currentApplicationVersionId);
            this.inputId(model.inputId);
            this.inputProcessingConfiguration(model.inputProcessingConfiguration);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Long getCurrentApplicationVersionId() {
            return this.currentApplicationVersionId;
        }

        @Override
        public final Builder currentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
            return this;
        }

        public final void setCurrentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
        }

        public final String getInputId() {
            return this.inputId;
        }

        @Override
        public final Builder inputId(String inputId) {
            this.inputId = inputId;
            return this;
        }

        public final void setInputId(String inputId) {
            this.inputId = inputId;
        }

        public final InputProcessingConfiguration.Builder getInputProcessingConfiguration() {
            return this.inputProcessingConfiguration != null ? this.inputProcessingConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder inputProcessingConfiguration(InputProcessingConfiguration inputProcessingConfiguration) {
            this.inputProcessingConfiguration = inputProcessingConfiguration;
            return this;
        }

        public final void setInputProcessingConfiguration(InputProcessingConfiguration.BuilderImpl inputProcessingConfiguration) {
            this.inputProcessingConfiguration = inputProcessingConfiguration != null ? inputProcessingConfiguration.build() : null;
        }

        public AddApplicationInputProcessingConfigurationRequest build() {
            return new AddApplicationInputProcessingConfigurationRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AddApplicationInputProcessingConfigurationRequest> {
        public Builder applicationName(String var1);

        public Builder currentApplicationVersionId(Long var1);

        public Builder inputId(String var1);

        public Builder inputProcessingConfiguration(InputProcessingConfiguration var1);

        default public Builder inputProcessingConfiguration(Consumer<InputProcessingConfiguration.Builder> inputProcessingConfiguration) {
            return this.inputProcessingConfiguration((InputProcessingConfiguration)((InputProcessingConfiguration.Builder)InputProcessingConfiguration.builder().apply(inputProcessingConfiguration)).build());
        }
    }
}

