/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOption;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AddApplicationCloudWatchLoggingOptionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AddApplicationCloudWatchLoggingOptionRequest> {
    private final String applicationName;
    private final Long currentApplicationVersionId;
    private final CloudWatchLoggingOption cloudWatchLoggingOption;

    private AddApplicationCloudWatchLoggingOptionRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.currentApplicationVersionId = builder.currentApplicationVersionId;
        this.cloudWatchLoggingOption = builder.cloudWatchLoggingOption;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public Long currentApplicationVersionId() {
        return this.currentApplicationVersionId;
    }

    public CloudWatchLoggingOption cloudWatchLoggingOption() {
        return this.cloudWatchLoggingOption;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentApplicationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLoggingOption());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddApplicationCloudWatchLoggingOptionRequest)) {
            return false;
        }
        AddApplicationCloudWatchLoggingOptionRequest other = (AddApplicationCloudWatchLoggingOptionRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.currentApplicationVersionId(), other.currentApplicationVersionId()) && Objects.equals(this.cloudWatchLoggingOption(), other.cloudWatchLoggingOption());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.currentApplicationVersionId() != null) {
            sb.append("CurrentApplicationVersionId: ").append(this.currentApplicationVersionId()).append(",");
        }
        if (this.cloudWatchLoggingOption() != null) {
            sb.append("CloudWatchLoggingOption: ").append(this.cloudWatchLoggingOption()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.of(clazz.cast(this.applicationName()));
            }
            case "CurrentApplicationVersionId": {
                return Optional.of(clazz.cast(this.currentApplicationVersionId()));
            }
            case "CloudWatchLoggingOption": {
                return Optional.of(clazz.cast(this.cloudWatchLoggingOption()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private Long currentApplicationVersionId;
        private CloudWatchLoggingOption cloudWatchLoggingOption;

        private BuilderImpl() {
        }

        private BuilderImpl(AddApplicationCloudWatchLoggingOptionRequest model) {
            this.applicationName(model.applicationName);
            this.currentApplicationVersionId(model.currentApplicationVersionId);
            this.cloudWatchLoggingOption(model.cloudWatchLoggingOption);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Long getCurrentApplicationVersionId() {
            return this.currentApplicationVersionId;
        }

        @Override
        public final Builder currentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
            return this;
        }

        public final void setCurrentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
        }

        public final CloudWatchLoggingOption.Builder getCloudWatchLoggingOption() {
            return this.cloudWatchLoggingOption != null ? this.cloudWatchLoggingOption.toBuilder() : null;
        }

        @Override
        public final Builder cloudWatchLoggingOption(CloudWatchLoggingOption cloudWatchLoggingOption) {
            this.cloudWatchLoggingOption = cloudWatchLoggingOption;
            return this;
        }

        public final void setCloudWatchLoggingOption(CloudWatchLoggingOption.BuilderImpl cloudWatchLoggingOption) {
            this.cloudWatchLoggingOption = cloudWatchLoggingOption != null ? cloudWatchLoggingOption.build() : null;
        }

        public AddApplicationCloudWatchLoggingOptionRequest build() {
            return new AddApplicationCloudWatchLoggingOptionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AddApplicationCloudWatchLoggingOptionRequest> {
        public Builder applicationName(String var1);

        public Builder currentApplicationVersionId(Long var1);

        public Builder cloudWatchLoggingOption(CloudWatchLoggingOption var1);

        default public Builder cloudWatchLoggingOption(Consumer<CloudWatchLoggingOption.Builder> cloudWatchLoggingOption) {
            return this.cloudWatchLoggingOption((CloudWatchLoggingOption)((CloudWatchLoggingOption.Builder)CloudWatchLoggingOption.builder().apply(cloudWatchLoggingOption)).build());
        }
    }
}

