/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesis.transform.PutRecordsResultEntryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutRecordsResultEntry
implements StructuredPojo,
ToCopyableBuilder<Builder, PutRecordsResultEntry> {
    private final String sequenceNumber;
    private final String shardId;
    private final String errorCode;
    private final String errorMessage;

    private PutRecordsResultEntry(BuilderImpl builder) {
        this.sequenceNumber = builder.sequenceNumber;
        this.shardId = builder.shardId;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
    }

    public String sequenceNumber() {
        return this.sequenceNumber;
    }

    public String shardId() {
        return this.shardId;
    }

    public String errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sequenceNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.shardId());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecordsResultEntry)) {
            return false;
        }
        PutRecordsResultEntry other = (PutRecordsResultEntry)obj;
        return Objects.equals(this.sequenceNumber(), other.sequenceNumber()) && Objects.equals(this.shardId(), other.shardId()) && Objects.equals(this.errorCode(), other.errorCode()) && Objects.equals(this.errorMessage(), other.errorMessage());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.sequenceNumber() != null) {
            sb.append("SequenceNumber: ").append(this.sequenceNumber()).append(",");
        }
        if (this.shardId() != null) {
            sb.append("ShardId: ").append(this.shardId()).append(",");
        }
        if (this.errorCode() != null) {
            sb.append("ErrorCode: ").append(this.errorCode()).append(",");
        }
        if (this.errorMessage() != null) {
            sb.append("ErrorMessage: ").append(this.errorMessage()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SequenceNumber": {
                return Optional.of(clazz.cast(this.sequenceNumber()));
            }
            case "ShardId": {
                return Optional.of(clazz.cast(this.shardId()));
            }
            case "ErrorCode": {
                return Optional.of(clazz.cast(this.errorCode()));
            }
            case "ErrorMessage": {
                return Optional.of(clazz.cast(this.errorMessage()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PutRecordsResultEntryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String sequenceNumber;
        private String shardId;
        private String errorCode;
        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRecordsResultEntry model) {
            this.sequenceNumber(model.sequenceNumber);
            this.shardId(model.shardId);
            this.errorCode(model.errorCode);
            this.errorMessage(model.errorMessage);
        }

        public final String getSequenceNumber() {
            return this.sequenceNumber;
        }

        @Override
        public final Builder sequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        public final void setSequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        public final String getShardId() {
            return this.shardId;
        }

        @Override
        public final Builder shardId(String shardId) {
            this.shardId = shardId;
            return this;
        }

        public final void setShardId(String shardId) {
            this.shardId = shardId;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public PutRecordsResultEntry build() {
            return new PutRecordsResultEntry(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutRecordsResultEntry> {
        public Builder sequenceNumber(String var1);

        public Builder shardId(String var1);

        public Builder errorCode(String var1);

        public Builder errorMessage(String var1);
    }
}

