/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.model.UpdateDestinationRequest;

@SdkInternalApi
public class UpdateDestinationRequestModelMarshaller {
    private static final MarshallingInfo<String> DELIVERYSTREAMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeliveryStreamName").build();
    private static final MarshallingInfo<String> CURRENTDELIVERYSTREAMVERSIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CurrentDeliveryStreamVersionId").build();
    private static final MarshallingInfo<String> DESTINATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DestinationId").build();
    private static final MarshallingInfo<StructuredPojo> S3DESTINATIONUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3DestinationUpdate").build();
    private static final MarshallingInfo<StructuredPojo> EXTENDEDS3DESTINATIONUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExtendedS3DestinationUpdate").build();
    private static final MarshallingInfo<StructuredPojo> REDSHIFTDESTINATIONUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RedshiftDestinationUpdate").build();
    private static final MarshallingInfo<StructuredPojo> ELASTICSEARCHDESTINATIONUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ElasticsearchDestinationUpdate").build();
    private static final MarshallingInfo<StructuredPojo> SPLUNKDESTINATIONUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SplunkDestinationUpdate").build();
    private static final UpdateDestinationRequestModelMarshaller INSTANCE = new UpdateDestinationRequestModelMarshaller();

    public static UpdateDestinationRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UpdateDestinationRequest updateDestinationRequest, ProtocolMarshaller protocolMarshaller) {
        if (updateDestinationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)updateDestinationRequest.deliveryStreamName(), DELIVERYSTREAMNAME_BINDING);
            protocolMarshaller.marshall((Object)updateDestinationRequest.currentDeliveryStreamVersionId(), CURRENTDELIVERYSTREAMVERSIONID_BINDING);
            protocolMarshaller.marshall((Object)updateDestinationRequest.destinationId(), DESTINATIONID_BINDING);
            protocolMarshaller.marshall((Object)updateDestinationRequest.s3DestinationUpdate(), S3DESTINATIONUPDATE_BINDING);
            protocolMarshaller.marshall((Object)updateDestinationRequest.extendedS3DestinationUpdate(), EXTENDEDS3DESTINATIONUPDATE_BINDING);
            protocolMarshaller.marshall((Object)updateDestinationRequest.redshiftDestinationUpdate(), REDSHIFTDESTINATIONUPDATE_BINDING);
            protocolMarshaller.marshall((Object)updateDestinationRequest.elasticsearchDestinationUpdate(), ELASTICSEARCHDESTINATIONUPDATE_BINDING);
            protocolMarshaller.marshall((Object)updateDestinationRequest.splunkDestinationUpdate(), SPLUNKDESTINATIONUPDATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

