/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.model.DeliveryStreamDescription;

@SdkInternalApi
public class DeliveryStreamDescriptionMarshaller {
    private static final MarshallingInfo<String> DELIVERYSTREAMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeliveryStreamName").build();
    private static final MarshallingInfo<String> DELIVERYSTREAMARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeliveryStreamARN").build();
    private static final MarshallingInfo<String> DELIVERYSTREAMSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeliveryStreamStatus").build();
    private static final MarshallingInfo<String> DELIVERYSTREAMTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeliveryStreamType").build();
    private static final MarshallingInfo<String> VERSIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VersionId").build();
    private static final MarshallingInfo<Instant> CREATETIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreateTimestamp").build();
    private static final MarshallingInfo<Instant> LASTUPDATETIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdateTimestamp").build();
    private static final MarshallingInfo<StructuredPojo> SOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Source").build();
    private static final MarshallingInfo<List> DESTINATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Destinations").build();
    private static final MarshallingInfo<Boolean> HASMOREDESTINATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HasMoreDestinations").build();
    private static final DeliveryStreamDescriptionMarshaller INSTANCE = new DeliveryStreamDescriptionMarshaller();

    public static DeliveryStreamDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DeliveryStreamDescription deliveryStreamDescription, ProtocolMarshaller protocolMarshaller) {
        if (deliveryStreamDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)deliveryStreamDescription.deliveryStreamName(), DELIVERYSTREAMNAME_BINDING);
            protocolMarshaller.marshall((Object)deliveryStreamDescription.deliveryStreamARN(), DELIVERYSTREAMARN_BINDING);
            protocolMarshaller.marshall((Object)deliveryStreamDescription.deliveryStreamStatusString(), DELIVERYSTREAMSTATUS_BINDING);
            protocolMarshaller.marshall((Object)deliveryStreamDescription.deliveryStreamTypeString(), DELIVERYSTREAMTYPE_BINDING);
            protocolMarshaller.marshall((Object)deliveryStreamDescription.versionId(), VERSIONID_BINDING);
            protocolMarshaller.marshall((Object)deliveryStreamDescription.createTimestamp(), CREATETIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)deliveryStreamDescription.lastUpdateTimestamp(), LASTUPDATETIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)deliveryStreamDescription.source(), SOURCE_BINDING);
            protocolMarshaller.marshall(deliveryStreamDescription.destinations(), DESTINATIONS_BINDING);
            protocolMarshaller.marshall((Object)deliveryStreamDescription.hasMoreDestinations(), HASMOREDESTINATIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

