/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.firehose.model.PutRecordBatchResponseEntry;
import software.amazon.awssdk.services.firehose.model.PutRecordBatchResponseEntryListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutRecordBatchResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, PutRecordBatchResponse> {
    private final Integer failedPutCount;
    private final List<PutRecordBatchResponseEntry> requestResponses;

    private PutRecordBatchResponse(BuilderImpl builder) {
        this.failedPutCount = builder.failedPutCount;
        this.requestResponses = builder.requestResponses;
    }

    public Integer failedPutCount() {
        return this.failedPutCount;
    }

    public List<PutRecordBatchResponseEntry> requestResponses() {
        return this.requestResponses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.failedPutCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestResponses());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecordBatchResponse)) {
            return false;
        }
        PutRecordBatchResponse other = (PutRecordBatchResponse)((Object)obj);
        return Objects.equals(this.failedPutCount(), other.failedPutCount()) && Objects.equals(this.requestResponses(), other.requestResponses());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.failedPutCount() != null) {
            sb.append("FailedPutCount: ").append(this.failedPutCount()).append(",");
        }
        if (this.requestResponses() != null) {
            sb.append("RequestResponses: ").append(this.requestResponses()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FailedPutCount": {
                return Optional.of(clazz.cast(this.failedPutCount()));
            }
            case "RequestResponses": {
                return Optional.of(clazz.cast(this.requestResponses()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Integer failedPutCount;
        private List<PutRecordBatchResponseEntry> requestResponses;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRecordBatchResponse model) {
            this.failedPutCount(model.failedPutCount);
            this.requestResponses(model.requestResponses);
        }

        public final Integer getFailedPutCount() {
            return this.failedPutCount;
        }

        @Override
        public final Builder failedPutCount(Integer failedPutCount) {
            this.failedPutCount = failedPutCount;
            return this;
        }

        public final void setFailedPutCount(Integer failedPutCount) {
            this.failedPutCount = failedPutCount;
        }

        public final Collection<PutRecordBatchResponseEntry.Builder> getRequestResponses() {
            return this.requestResponses != null ? (Collection)this.requestResponses.stream().map(PutRecordBatchResponseEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder requestResponses(Collection<PutRecordBatchResponseEntry> requestResponses) {
            this.requestResponses = PutRecordBatchResponseEntryListCopier.copy(requestResponses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requestResponses(PutRecordBatchResponseEntry ... requestResponses) {
            this.requestResponses(Arrays.asList(requestResponses));
            return this;
        }

        public final void setRequestResponses(Collection<PutRecordBatchResponseEntry.BuilderImpl> requestResponses) {
            this.requestResponses = PutRecordBatchResponseEntryListCopier.copyFromBuilder(requestResponses);
        }

        public PutRecordBatchResponse build() {
            return new PutRecordBatchResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutRecordBatchResponse> {
        public Builder failedPutCount(Integer var1);

        public Builder requestResponses(Collection<PutRecordBatchResponseEntry> var1);

        public Builder requestResponses(PutRecordBatchResponseEntry ... var1);
    }
}

