/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.transform.KMSEncryptionConfigMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class KMSEncryptionConfig
implements StructuredPojo,
ToCopyableBuilder<Builder, KMSEncryptionConfig> {
    private final String awskmsKeyARN;

    private KMSEncryptionConfig(BuilderImpl builder) {
        this.awskmsKeyARN = builder.awskmsKeyARN;
    }

    public String awskmsKeyARN() {
        return this.awskmsKeyARN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.awskmsKeyARN());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KMSEncryptionConfig)) {
            return false;
        }
        KMSEncryptionConfig other = (KMSEncryptionConfig)obj;
        return Objects.equals(this.awskmsKeyARN(), other.awskmsKeyARN());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.awskmsKeyARN() != null) {
            sb.append("AWSKMSKeyARN: ").append(this.awskmsKeyARN()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AWSKMSKeyARN": {
                return Optional.of(clazz.cast(this.awskmsKeyARN()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KMSEncryptionConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String awskmsKeyARN;

        private BuilderImpl() {
        }

        private BuilderImpl(KMSEncryptionConfig model) {
            this.awskmsKeyARN(model.awskmsKeyARN);
        }

        public final String getAWSKMSKeyARN() {
            return this.awskmsKeyARN;
        }

        @Override
        public final Builder awskmsKeyARN(String awskmsKeyARN) {
            this.awskmsKeyARN = awskmsKeyARN;
            return this;
        }

        public final void setAWSKMSKeyARN(String awskmsKeyARN) {
            this.awskmsKeyARN = awskmsKeyARN;
        }

        public KMSEncryptionConfig build() {
            return new KMSEncryptionConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, KMSEncryptionConfig> {
        public Builder awskmsKeyARN(String var1);
    }
}

