/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.KinesisFirehoseOutputMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class KinesisFirehoseOutput
implements StructuredPojo,
ToCopyableBuilder<Builder, KinesisFirehoseOutput> {
    private final String resourceARN;
    private final String roleARN;

    private KinesisFirehoseOutput(BuilderImpl builder) {
        this.resourceARN = builder.resourceARN;
        this.roleARN = builder.roleARN;
    }

    public String resourceARN() {
        return this.resourceARN;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.resourceARN() == null ? 0 : this.resourceARN().hashCode());
        hashCode = 31 * hashCode + (this.roleARN() == null ? 0 : this.roleARN().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisFirehoseOutput)) {
            return false;
        }
        KinesisFirehoseOutput other = (KinesisFirehoseOutput)obj;
        if (other.resourceARN() == null ^ this.resourceARN() == null) {
            return false;
        }
        if (other.resourceARN() != null && !other.resourceARN().equals(this.resourceARN())) {
            return false;
        }
        if (other.roleARN() == null ^ this.roleARN() == null) {
            return false;
        }
        return other.roleARN() == null || other.roleARN().equals(this.roleARN());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.resourceARN() != null) {
            sb.append("ResourceARN: ").append(this.resourceARN()).append(",");
        }
        if (this.roleARN() != null) {
            sb.append("RoleARN: ").append(this.roleARN()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceARN": {
                return Optional.of(clazz.cast(this.resourceARN()));
            }
            case "RoleARN": {
                return Optional.of(clazz.cast(this.roleARN()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KinesisFirehoseOutputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceARN;
        private String roleARN;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisFirehoseOutput model) {
            this.resourceARN(model.resourceARN);
            this.roleARN(model.roleARN);
        }

        public final String getResourceARN() {
            return this.resourceARN;
        }

        @Override
        public final Builder resourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
            return this;
        }

        public final void setResourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public KinesisFirehoseOutput build() {
            return new KinesisFirehoseOutput(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, KinesisFirehoseOutput> {
        public Builder resourceARN(String var1);

        public Builder roleARN(String var1);
    }
}

