/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.InputParallelism;
import software.amazon.awssdk.services.kinesisanalytics.model.KinesisFirehoseInput;
import software.amazon.awssdk.services.kinesisanalytics.model.KinesisStreamsInput;
import software.amazon.awssdk.services.kinesisanalytics.model.SourceSchema;
import software.amazon.awssdk.services.kinesisanalytics.transform.InputMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Input
implements StructuredPojo,
ToCopyableBuilder<Builder, Input> {
    private final String namePrefix;
    private final KinesisStreamsInput kinesisStreamsInput;
    private final KinesisFirehoseInput kinesisFirehoseInput;
    private final InputParallelism inputParallelism;
    private final SourceSchema inputSchema;

    private Input(BuilderImpl builder) {
        this.namePrefix = builder.namePrefix;
        this.kinesisStreamsInput = builder.kinesisStreamsInput;
        this.kinesisFirehoseInput = builder.kinesisFirehoseInput;
        this.inputParallelism = builder.inputParallelism;
        this.inputSchema = builder.inputSchema;
    }

    public String namePrefix() {
        return this.namePrefix;
    }

    public KinesisStreamsInput kinesisStreamsInput() {
        return this.kinesisStreamsInput;
    }

    public KinesisFirehoseInput kinesisFirehoseInput() {
        return this.kinesisFirehoseInput;
    }

    public InputParallelism inputParallelism() {
        return this.inputParallelism;
    }

    public SourceSchema inputSchema() {
        return this.inputSchema;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.namePrefix() == null ? 0 : this.namePrefix().hashCode());
        hashCode = 31 * hashCode + (this.kinesisStreamsInput() == null ? 0 : this.kinesisStreamsInput().hashCode());
        hashCode = 31 * hashCode + (this.kinesisFirehoseInput() == null ? 0 : this.kinesisFirehoseInput().hashCode());
        hashCode = 31 * hashCode + (this.inputParallelism() == null ? 0 : this.inputParallelism().hashCode());
        hashCode = 31 * hashCode + (this.inputSchema() == null ? 0 : this.inputSchema().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Input)) {
            return false;
        }
        Input other = (Input)obj;
        if (other.namePrefix() == null ^ this.namePrefix() == null) {
            return false;
        }
        if (other.namePrefix() != null && !other.namePrefix().equals(this.namePrefix())) {
            return false;
        }
        if (other.kinesisStreamsInput() == null ^ this.kinesisStreamsInput() == null) {
            return false;
        }
        if (other.kinesisStreamsInput() != null && !other.kinesisStreamsInput().equals(this.kinesisStreamsInput())) {
            return false;
        }
        if (other.kinesisFirehoseInput() == null ^ this.kinesisFirehoseInput() == null) {
            return false;
        }
        if (other.kinesisFirehoseInput() != null && !other.kinesisFirehoseInput().equals(this.kinesisFirehoseInput())) {
            return false;
        }
        if (other.inputParallelism() == null ^ this.inputParallelism() == null) {
            return false;
        }
        if (other.inputParallelism() != null && !other.inputParallelism().equals(this.inputParallelism())) {
            return false;
        }
        if (other.inputSchema() == null ^ this.inputSchema() == null) {
            return false;
        }
        return other.inputSchema() == null || other.inputSchema().equals(this.inputSchema());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.namePrefix() != null) {
            sb.append("NamePrefix: ").append(this.namePrefix()).append(",");
        }
        if (this.kinesisStreamsInput() != null) {
            sb.append("KinesisStreamsInput: ").append(this.kinesisStreamsInput()).append(",");
        }
        if (this.kinesisFirehoseInput() != null) {
            sb.append("KinesisFirehoseInput: ").append(this.kinesisFirehoseInput()).append(",");
        }
        if (this.inputParallelism() != null) {
            sb.append("InputParallelism: ").append(this.inputParallelism()).append(",");
        }
        if (this.inputSchema() != null) {
            sb.append("InputSchema: ").append(this.inputSchema()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NamePrefix": {
                return Optional.of(clazz.cast(this.namePrefix()));
            }
            case "KinesisStreamsInput": {
                return Optional.of(clazz.cast(this.kinesisStreamsInput()));
            }
            case "KinesisFirehoseInput": {
                return Optional.of(clazz.cast(this.kinesisFirehoseInput()));
            }
            case "InputParallelism": {
                return Optional.of(clazz.cast(this.inputParallelism()));
            }
            case "InputSchema": {
                return Optional.of(clazz.cast(this.inputSchema()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String namePrefix;
        private KinesisStreamsInput kinesisStreamsInput;
        private KinesisFirehoseInput kinesisFirehoseInput;
        private InputParallelism inputParallelism;
        private SourceSchema inputSchema;

        private BuilderImpl() {
        }

        private BuilderImpl(Input model) {
            this.namePrefix(model.namePrefix);
            this.kinesisStreamsInput(model.kinesisStreamsInput);
            this.kinesisFirehoseInput(model.kinesisFirehoseInput);
            this.inputParallelism(model.inputParallelism);
            this.inputSchema(model.inputSchema);
        }

        public final String getNamePrefix() {
            return this.namePrefix;
        }

        @Override
        public final Builder namePrefix(String namePrefix) {
            this.namePrefix = namePrefix;
            return this;
        }

        public final void setNamePrefix(String namePrefix) {
            this.namePrefix = namePrefix;
        }

        public final KinesisStreamsInput.Builder getKinesisStreamsInput() {
            return this.kinesisStreamsInput != null ? this.kinesisStreamsInput.toBuilder() : null;
        }

        @Override
        public final Builder kinesisStreamsInput(KinesisStreamsInput kinesisStreamsInput) {
            this.kinesisStreamsInput = kinesisStreamsInput;
            return this;
        }

        public final void setKinesisStreamsInput(KinesisStreamsInput.BuilderImpl kinesisStreamsInput) {
            this.kinesisStreamsInput = kinesisStreamsInput != null ? kinesisStreamsInput.build() : null;
        }

        public final KinesisFirehoseInput.Builder getKinesisFirehoseInput() {
            return this.kinesisFirehoseInput != null ? this.kinesisFirehoseInput.toBuilder() : null;
        }

        @Override
        public final Builder kinesisFirehoseInput(KinesisFirehoseInput kinesisFirehoseInput) {
            this.kinesisFirehoseInput = kinesisFirehoseInput;
            return this;
        }

        public final void setKinesisFirehoseInput(KinesisFirehoseInput.BuilderImpl kinesisFirehoseInput) {
            this.kinesisFirehoseInput = kinesisFirehoseInput != null ? kinesisFirehoseInput.build() : null;
        }

        public final InputParallelism.Builder getInputParallelism() {
            return this.inputParallelism != null ? this.inputParallelism.toBuilder() : null;
        }

        @Override
        public final Builder inputParallelism(InputParallelism inputParallelism) {
            this.inputParallelism = inputParallelism;
            return this;
        }

        public final void setInputParallelism(InputParallelism.BuilderImpl inputParallelism) {
            this.inputParallelism = inputParallelism != null ? inputParallelism.build() : null;
        }

        public final SourceSchema.Builder getInputSchema() {
            return this.inputSchema != null ? this.inputSchema.toBuilder() : null;
        }

        @Override
        public final Builder inputSchema(SourceSchema inputSchema) {
            this.inputSchema = inputSchema;
            return this;
        }

        public final void setInputSchema(SourceSchema.BuilderImpl inputSchema) {
            this.inputSchema = inputSchema != null ? inputSchema.build() : null;
        }

        public Input build() {
            return new Input(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Input> {
        public Builder namePrefix(String var1);

        public Builder kinesisStreamsInput(KinesisStreamsInput var1);

        public Builder kinesisFirehoseInput(KinesisFirehoseInput var1);

        public Builder inputParallelism(InputParallelism var1);

        public Builder inputSchema(SourceSchema var1);
    }
}

