/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.CloudWatchLoggingOptionUpdateMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CloudWatchLoggingOptionUpdate
implements StructuredPojo,
ToCopyableBuilder<Builder, CloudWatchLoggingOptionUpdate> {
    private final String cloudWatchLoggingOptionId;
    private final String logStreamARNUpdate;
    private final String roleARNUpdate;

    private CloudWatchLoggingOptionUpdate(BuilderImpl builder) {
        this.cloudWatchLoggingOptionId = builder.cloudWatchLoggingOptionId;
        this.logStreamARNUpdate = builder.logStreamARNUpdate;
        this.roleARNUpdate = builder.roleARNUpdate;
    }

    public String cloudWatchLoggingOptionId() {
        return this.cloudWatchLoggingOptionId;
    }

    public String logStreamARNUpdate() {
        return this.logStreamARNUpdate;
    }

    public String roleARNUpdate() {
        return this.roleARNUpdate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.cloudWatchLoggingOptionId() == null ? 0 : this.cloudWatchLoggingOptionId().hashCode());
        hashCode = 31 * hashCode + (this.logStreamARNUpdate() == null ? 0 : this.logStreamARNUpdate().hashCode());
        hashCode = 31 * hashCode + (this.roleARNUpdate() == null ? 0 : this.roleARNUpdate().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchLoggingOptionUpdate)) {
            return false;
        }
        CloudWatchLoggingOptionUpdate other = (CloudWatchLoggingOptionUpdate)obj;
        if (other.cloudWatchLoggingOptionId() == null ^ this.cloudWatchLoggingOptionId() == null) {
            return false;
        }
        if (other.cloudWatchLoggingOptionId() != null && !other.cloudWatchLoggingOptionId().equals(this.cloudWatchLoggingOptionId())) {
            return false;
        }
        if (other.logStreamARNUpdate() == null ^ this.logStreamARNUpdate() == null) {
            return false;
        }
        if (other.logStreamARNUpdate() != null && !other.logStreamARNUpdate().equals(this.logStreamARNUpdate())) {
            return false;
        }
        if (other.roleARNUpdate() == null ^ this.roleARNUpdate() == null) {
            return false;
        }
        return other.roleARNUpdate() == null || other.roleARNUpdate().equals(this.roleARNUpdate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.cloudWatchLoggingOptionId() != null) {
            sb.append("CloudWatchLoggingOptionId: ").append(this.cloudWatchLoggingOptionId()).append(",");
        }
        if (this.logStreamARNUpdate() != null) {
            sb.append("LogStreamARNUpdate: ").append(this.logStreamARNUpdate()).append(",");
        }
        if (this.roleARNUpdate() != null) {
            sb.append("RoleARNUpdate: ").append(this.roleARNUpdate()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CloudWatchLoggingOptionId": {
                return Optional.of(clazz.cast(this.cloudWatchLoggingOptionId()));
            }
            case "LogStreamARNUpdate": {
                return Optional.of(clazz.cast(this.logStreamARNUpdate()));
            }
            case "RoleARNUpdate": {
                return Optional.of(clazz.cast(this.roleARNUpdate()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CloudWatchLoggingOptionUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String cloudWatchLoggingOptionId;
        private String logStreamARNUpdate;
        private String roleARNUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchLoggingOptionUpdate model) {
            this.cloudWatchLoggingOptionId(model.cloudWatchLoggingOptionId);
            this.logStreamARNUpdate(model.logStreamARNUpdate);
            this.roleARNUpdate(model.roleARNUpdate);
        }

        public final String getCloudWatchLoggingOptionId() {
            return this.cloudWatchLoggingOptionId;
        }

        @Override
        public final Builder cloudWatchLoggingOptionId(String cloudWatchLoggingOptionId) {
            this.cloudWatchLoggingOptionId = cloudWatchLoggingOptionId;
            return this;
        }

        public final void setCloudWatchLoggingOptionId(String cloudWatchLoggingOptionId) {
            this.cloudWatchLoggingOptionId = cloudWatchLoggingOptionId;
        }

        public final String getLogStreamARNUpdate() {
            return this.logStreamARNUpdate;
        }

        @Override
        public final Builder logStreamARNUpdate(String logStreamARNUpdate) {
            this.logStreamARNUpdate = logStreamARNUpdate;
            return this;
        }

        public final void setLogStreamARNUpdate(String logStreamARNUpdate) {
            this.logStreamARNUpdate = logStreamARNUpdate;
        }

        public final String getRoleARNUpdate() {
            return this.roleARNUpdate;
        }

        @Override
        public final Builder roleARNUpdate(String roleARNUpdate) {
            this.roleARNUpdate = roleARNUpdate;
            return this;
        }

        public final void setRoleARNUpdate(String roleARNUpdate) {
            this.roleARNUpdate = roleARNUpdate;
        }

        public CloudWatchLoggingOptionUpdate build() {
            return new CloudWatchLoggingOptionUpdate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CloudWatchLoggingOptionUpdate> {
        public Builder cloudWatchLoggingOptionId(String var1);

        public Builder logStreamARNUpdate(String var1);

        public Builder roleARNUpdate(String var1);
    }
}

