/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.kinesis.model.StreamDescription;
import software.amazon.awssdk.services.kinesis.transform.EnhancedMetricsUnmarshaller;
import software.amazon.awssdk.services.kinesis.transform.ShardUnmarshaller;

public class StreamDescriptionUnmarshaller
implements Unmarshaller<StreamDescription, JsonUnmarshallerContext> {
    private static final StreamDescriptionUnmarshaller INSTANCE = new StreamDescriptionUnmarshaller();

    public StreamDescription unmarshall(JsonUnmarshallerContext context) throws Exception {
        StreamDescription.Builder streamDescriptionBuilder = StreamDescription.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("StreamName", targetDepth)) {
                    context.nextToken();
                    streamDescriptionBuilder.streamName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("StreamARN", targetDepth)) {
                    context.nextToken();
                    streamDescriptionBuilder.streamARN((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("StreamStatus", targetDepth)) {
                    context.nextToken();
                    streamDescriptionBuilder.streamStatus((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Shards", targetDepth)) {
                    context.nextToken();
                    streamDescriptionBuilder.shards(new ListUnmarshaller((Unmarshaller)ShardUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("HasMoreShards", targetDepth)) {
                    context.nextToken();
                    streamDescriptionBuilder.hasMoreShards((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("RetentionPeriodHours", targetDepth)) {
                    context.nextToken();
                    streamDescriptionBuilder.retentionPeriodHours((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("StreamCreationTimestamp", targetDepth)) {
                    context.nextToken();
                    streamDescriptionBuilder.streamCreationTimestamp((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("EnhancedMonitoring", targetDepth)) {
                    context.nextToken();
                    streamDescriptionBuilder.enhancedMonitoring(new ListUnmarshaller((Unmarshaller)EnhancedMetricsUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (StreamDescription)streamDescriptionBuilder.build();
    }

    public static StreamDescriptionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

