/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.kinesis.model.ScalingType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateShardCountRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateShardCountRequest> {
    private final String streamName;
    private final Integer targetShardCount;
    private final String scalingType;

    private UpdateShardCountRequest(BuilderImpl builder) {
        this.streamName = builder.streamName;
        this.targetShardCount = builder.targetShardCount;
        this.scalingType = builder.scalingType;
    }

    public String streamName() {
        return this.streamName;
    }

    public Integer targetShardCount() {
        return this.targetShardCount;
    }

    public ScalingType scalingType() {
        return ScalingType.fromValue(this.scalingType);
    }

    public String scalingTypeString() {
        return this.scalingType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.streamName() == null ? 0 : this.streamName().hashCode());
        hashCode = 31 * hashCode + (this.targetShardCount() == null ? 0 : this.targetShardCount().hashCode());
        hashCode = 31 * hashCode + (this.scalingTypeString() == null ? 0 : this.scalingTypeString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateShardCountRequest)) {
            return false;
        }
        UpdateShardCountRequest other = (UpdateShardCountRequest)((Object)obj);
        if (other.streamName() == null ^ this.streamName() == null) {
            return false;
        }
        if (other.streamName() != null && !other.streamName().equals(this.streamName())) {
            return false;
        }
        if (other.targetShardCount() == null ^ this.targetShardCount() == null) {
            return false;
        }
        if (other.targetShardCount() != null && !other.targetShardCount().equals(this.targetShardCount())) {
            return false;
        }
        if (other.scalingTypeString() == null ^ this.scalingTypeString() == null) {
            return false;
        }
        return other.scalingTypeString() == null || other.scalingTypeString().equals(this.scalingTypeString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.streamName() != null) {
            sb.append("StreamName: ").append(this.streamName()).append(",");
        }
        if (this.targetShardCount() != null) {
            sb.append("TargetShardCount: ").append(this.targetShardCount()).append(",");
        }
        if (this.scalingTypeString() != null) {
            sb.append("ScalingType: ").append(this.scalingTypeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.of(clazz.cast(this.streamName()));
            }
            case "TargetShardCount": {
                return Optional.of(clazz.cast(this.targetShardCount()));
            }
            case "ScalingType": {
                return Optional.of(clazz.cast(this.scalingTypeString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String streamName;
        private Integer targetShardCount;
        private String scalingType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateShardCountRequest model) {
            this.streamName(model.streamName);
            this.targetShardCount(model.targetShardCount);
            this.scalingType(model.scalingType);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final Integer getTargetShardCount() {
            return this.targetShardCount;
        }

        @Override
        public final Builder targetShardCount(Integer targetShardCount) {
            this.targetShardCount = targetShardCount;
            return this;
        }

        public final void setTargetShardCount(Integer targetShardCount) {
            this.targetShardCount = targetShardCount;
        }

        public final String getScalingType() {
            return this.scalingType;
        }

        @Override
        public final Builder scalingType(String scalingType) {
            this.scalingType = scalingType;
            return this;
        }

        @Override
        public final Builder scalingType(ScalingType scalingType) {
            this.scalingType(scalingType.toString());
            return this;
        }

        public final void setScalingType(String scalingType) {
            this.scalingType = scalingType;
        }

        public UpdateShardCountRequest build() {
            return new UpdateShardCountRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateShardCountRequest> {
        public Builder streamName(String var1);

        public Builder targetShardCount(Integer var1);

        public Builder scalingType(String var1);

        public Builder scalingType(ScalingType var1);
    }
}

