/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.firehose.model.ProcessingConfiguration;

@SdkInternalApi
public class ProcessingConfigurationMarshaller {
    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Enabled").build();
    private static final MarshallingInfo<List> PROCESSORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Processors").build();
    private static final ProcessingConfigurationMarshaller INSTANCE = new ProcessingConfigurationMarshaller();

    public static ProcessingConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ProcessingConfiguration processingConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (processingConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)processingConfiguration.enabled(), ENABLED_BINDING);
            protocolMarshaller.marshall(processingConfiguration.processors(), PROCESSORS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

