/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.firehose.model.ElasticsearchDestinationConfiguration;
import software.amazon.awssdk.services.firehose.model.ExtendedS3DestinationConfiguration;
import software.amazon.awssdk.services.firehose.model.RedshiftDestinationConfiguration;
import software.amazon.awssdk.services.firehose.model.S3DestinationConfiguration;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateDeliveryStreamRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateDeliveryStreamRequest> {
    private final String deliveryStreamName;
    private final S3DestinationConfiguration s3DestinationConfiguration;
    private final ExtendedS3DestinationConfiguration extendedS3DestinationConfiguration;
    private final RedshiftDestinationConfiguration redshiftDestinationConfiguration;
    private final ElasticsearchDestinationConfiguration elasticsearchDestinationConfiguration;

    private CreateDeliveryStreamRequest(BuilderImpl builder) {
        this.deliveryStreamName = builder.deliveryStreamName;
        this.s3DestinationConfiguration = builder.s3DestinationConfiguration;
        this.extendedS3DestinationConfiguration = builder.extendedS3DestinationConfiguration;
        this.redshiftDestinationConfiguration = builder.redshiftDestinationConfiguration;
        this.elasticsearchDestinationConfiguration = builder.elasticsearchDestinationConfiguration;
    }

    public String deliveryStreamName() {
        return this.deliveryStreamName;
    }

    public S3DestinationConfiguration s3DestinationConfiguration() {
        return this.s3DestinationConfiguration;
    }

    public ExtendedS3DestinationConfiguration extendedS3DestinationConfiguration() {
        return this.extendedS3DestinationConfiguration;
    }

    public RedshiftDestinationConfiguration redshiftDestinationConfiguration() {
        return this.redshiftDestinationConfiguration;
    }

    public ElasticsearchDestinationConfiguration elasticsearchDestinationConfiguration() {
        return this.elasticsearchDestinationConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.deliveryStreamName() == null ? 0 : this.deliveryStreamName().hashCode());
        hashCode = 31 * hashCode + (this.s3DestinationConfiguration() == null ? 0 : this.s3DestinationConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.extendedS3DestinationConfiguration() == null ? 0 : this.extendedS3DestinationConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.redshiftDestinationConfiguration() == null ? 0 : this.redshiftDestinationConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.elasticsearchDestinationConfiguration() == null ? 0 : this.elasticsearchDestinationConfiguration().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeliveryStreamRequest)) {
            return false;
        }
        CreateDeliveryStreamRequest other = (CreateDeliveryStreamRequest)((Object)obj);
        if (other.deliveryStreamName() == null ^ this.deliveryStreamName() == null) {
            return false;
        }
        if (other.deliveryStreamName() != null && !other.deliveryStreamName().equals(this.deliveryStreamName())) {
            return false;
        }
        if (other.s3DestinationConfiguration() == null ^ this.s3DestinationConfiguration() == null) {
            return false;
        }
        if (other.s3DestinationConfiguration() != null && !other.s3DestinationConfiguration().equals(this.s3DestinationConfiguration())) {
            return false;
        }
        if (other.extendedS3DestinationConfiguration() == null ^ this.extendedS3DestinationConfiguration() == null) {
            return false;
        }
        if (other.extendedS3DestinationConfiguration() != null && !other.extendedS3DestinationConfiguration().equals(this.extendedS3DestinationConfiguration())) {
            return false;
        }
        if (other.redshiftDestinationConfiguration() == null ^ this.redshiftDestinationConfiguration() == null) {
            return false;
        }
        if (other.redshiftDestinationConfiguration() != null && !other.redshiftDestinationConfiguration().equals(this.redshiftDestinationConfiguration())) {
            return false;
        }
        if (other.elasticsearchDestinationConfiguration() == null ^ this.elasticsearchDestinationConfiguration() == null) {
            return false;
        }
        return other.elasticsearchDestinationConfiguration() == null || other.elasticsearchDestinationConfiguration().equals(this.elasticsearchDestinationConfiguration());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.deliveryStreamName() != null) {
            sb.append("DeliveryStreamName: ").append(this.deliveryStreamName()).append(",");
        }
        if (this.s3DestinationConfiguration() != null) {
            sb.append("S3DestinationConfiguration: ").append(this.s3DestinationConfiguration()).append(",");
        }
        if (this.extendedS3DestinationConfiguration() != null) {
            sb.append("ExtendedS3DestinationConfiguration: ").append(this.extendedS3DestinationConfiguration()).append(",");
        }
        if (this.redshiftDestinationConfiguration() != null) {
            sb.append("RedshiftDestinationConfiguration: ").append(this.redshiftDestinationConfiguration()).append(",");
        }
        if (this.elasticsearchDestinationConfiguration() != null) {
            sb.append("ElasticsearchDestinationConfiguration: ").append(this.elasticsearchDestinationConfiguration()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeliveryStreamName": {
                return Optional.of(clazz.cast(this.deliveryStreamName()));
            }
            case "S3DestinationConfiguration": {
                return Optional.of(clazz.cast(this.s3DestinationConfiguration()));
            }
            case "ExtendedS3DestinationConfiguration": {
                return Optional.of(clazz.cast(this.extendedS3DestinationConfiguration()));
            }
            case "RedshiftDestinationConfiguration": {
                return Optional.of(clazz.cast(this.redshiftDestinationConfiguration()));
            }
            case "ElasticsearchDestinationConfiguration": {
                return Optional.of(clazz.cast(this.elasticsearchDestinationConfiguration()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String deliveryStreamName;
        private S3DestinationConfiguration s3DestinationConfiguration;
        private ExtendedS3DestinationConfiguration extendedS3DestinationConfiguration;
        private RedshiftDestinationConfiguration redshiftDestinationConfiguration;
        private ElasticsearchDestinationConfiguration elasticsearchDestinationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeliveryStreamRequest model) {
            this.deliveryStreamName(model.deliveryStreamName);
            this.s3DestinationConfiguration(model.s3DestinationConfiguration);
            this.extendedS3DestinationConfiguration(model.extendedS3DestinationConfiguration);
            this.redshiftDestinationConfiguration(model.redshiftDestinationConfiguration);
            this.elasticsearchDestinationConfiguration(model.elasticsearchDestinationConfiguration);
        }

        public final String getDeliveryStreamName() {
            return this.deliveryStreamName;
        }

        @Override
        public final Builder deliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
            return this;
        }

        public final void setDeliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
        }

        public final S3DestinationConfiguration.Builder getS3DestinationConfiguration() {
            return this.s3DestinationConfiguration != null ? this.s3DestinationConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder s3DestinationConfiguration(S3DestinationConfiguration s3DestinationConfiguration) {
            this.s3DestinationConfiguration = s3DestinationConfiguration;
            return this;
        }

        public final void setS3DestinationConfiguration(S3DestinationConfiguration.BuilderImpl s3DestinationConfiguration) {
            this.s3DestinationConfiguration = s3DestinationConfiguration != null ? s3DestinationConfiguration.build() : null;
        }

        public final ExtendedS3DestinationConfiguration.Builder getExtendedS3DestinationConfiguration() {
            return this.extendedS3DestinationConfiguration != null ? this.extendedS3DestinationConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder extendedS3DestinationConfiguration(ExtendedS3DestinationConfiguration extendedS3DestinationConfiguration) {
            this.extendedS3DestinationConfiguration = extendedS3DestinationConfiguration;
            return this;
        }

        public final void setExtendedS3DestinationConfiguration(ExtendedS3DestinationConfiguration.BuilderImpl extendedS3DestinationConfiguration) {
            this.extendedS3DestinationConfiguration = extendedS3DestinationConfiguration != null ? extendedS3DestinationConfiguration.build() : null;
        }

        public final RedshiftDestinationConfiguration.Builder getRedshiftDestinationConfiguration() {
            return this.redshiftDestinationConfiguration != null ? this.redshiftDestinationConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder redshiftDestinationConfiguration(RedshiftDestinationConfiguration redshiftDestinationConfiguration) {
            this.redshiftDestinationConfiguration = redshiftDestinationConfiguration;
            return this;
        }

        public final void setRedshiftDestinationConfiguration(RedshiftDestinationConfiguration.BuilderImpl redshiftDestinationConfiguration) {
            this.redshiftDestinationConfiguration = redshiftDestinationConfiguration != null ? redshiftDestinationConfiguration.build() : null;
        }

        public final ElasticsearchDestinationConfiguration.Builder getElasticsearchDestinationConfiguration() {
            return this.elasticsearchDestinationConfiguration != null ? this.elasticsearchDestinationConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder elasticsearchDestinationConfiguration(ElasticsearchDestinationConfiguration elasticsearchDestinationConfiguration) {
            this.elasticsearchDestinationConfiguration = elasticsearchDestinationConfiguration;
            return this;
        }

        public final void setElasticsearchDestinationConfiguration(ElasticsearchDestinationConfiguration.BuilderImpl elasticsearchDestinationConfiguration) {
            this.elasticsearchDestinationConfiguration = elasticsearchDestinationConfiguration != null ? elasticsearchDestinationConfiguration.build() : null;
        }

        public CreateDeliveryStreamRequest build() {
            return new CreateDeliveryStreamRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateDeliveryStreamRequest> {
        public Builder deliveryStreamName(String var1);

        public Builder s3DestinationConfiguration(S3DestinationConfiguration var1);

        public Builder extendedS3DestinationConfiguration(ExtendedS3DestinationConfiguration var1);

        public Builder redshiftDestinationConfiguration(RedshiftDestinationConfiguration var1);

        public Builder elasticsearchDestinationConfiguration(ElasticsearchDestinationConfiguration var1);
    }
}

