/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSource;

@SdkInternalApi
public class ReferenceDataSourceMarshaller {
    private static final MarshallingInfo<String> TABLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableName").build();
    private static final MarshallingInfo<StructuredPojo> S3REFERENCEDATASOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3ReferenceDataSource").build();
    private static final MarshallingInfo<StructuredPojo> REFERENCESCHEMA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReferenceSchema").build();
    private static final ReferenceDataSourceMarshaller INSTANCE = new ReferenceDataSourceMarshaller();

    public static ReferenceDataSourceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ReferenceDataSource referenceDataSource, ProtocolMarshaller protocolMarshaller) {
        if (referenceDataSource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)referenceDataSource.tableName(), TABLENAME_BINDING);
            protocolMarshaller.marshall((Object)referenceDataSource.s3ReferenceDataSource(), S3REFERENCEDATASOURCE_BINDING);
            protocolMarshaller.marshall((Object)referenceDataSource.referenceSchema(), REFERENCESCHEMA_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

