/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.InputUpdate;

@SdkInternalApi
public class InputUpdateMarshaller {
    private static final MarshallingInfo<String> INPUTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputId").build();
    private static final MarshallingInfo<String> NAMEPREFIXUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NamePrefixUpdate").build();
    private static final MarshallingInfo<StructuredPojo> KINESISSTREAMSINPUTUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KinesisStreamsInputUpdate").build();
    private static final MarshallingInfo<StructuredPojo> KINESISFIREHOSEINPUTUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KinesisFirehoseInputUpdate").build();
    private static final MarshallingInfo<StructuredPojo> INPUTSCHEMAUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputSchemaUpdate").build();
    private static final MarshallingInfo<StructuredPojo> INPUTPARALLELISMUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputParallelismUpdate").build();
    private static final InputUpdateMarshaller INSTANCE = new InputUpdateMarshaller();

    public static InputUpdateMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InputUpdate inputUpdate, ProtocolMarshaller protocolMarshaller) {
        if (inputUpdate == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)inputUpdate.inputId(), INPUTID_BINDING);
            protocolMarshaller.marshall((Object)inputUpdate.namePrefixUpdate(), NAMEPREFIXUPDATE_BINDING);
            protocolMarshaller.marshall((Object)inputUpdate.kinesisStreamsInputUpdate(), KINESISSTREAMSINPUTUPDATE_BINDING);
            protocolMarshaller.marshall((Object)inputUpdate.kinesisFirehoseInputUpdate(), KINESISFIREHOSEINPUTUPDATE_BINDING);
            protocolMarshaller.marshall((Object)inputUpdate.inputSchemaUpdate(), INPUTSCHEMAUPDATE_BINDING);
            protocolMarshaller.marshall((Object)inputUpdate.inputParallelismUpdate(), INPUTPARALLELISMUPDATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

