/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOption;

@SdkInternalApi
public class CloudWatchLoggingOptionMarshaller {
    private static final MarshallingInfo<String> LOGSTREAMARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LogStreamARN").build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleARN").build();
    private static final CloudWatchLoggingOptionMarshaller INSTANCE = new CloudWatchLoggingOptionMarshaller();

    public static CloudWatchLoggingOptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CloudWatchLoggingOption cloudWatchLoggingOption, ProtocolMarshaller protocolMarshaller) {
        if (cloudWatchLoggingOption == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)cloudWatchLoggingOption.logStreamARN(), LOGSTREAMARN_BINDING);
            protocolMarshaller.marshall((Object)cloudWatchLoggingOption.roleARN(), ROLEARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

