/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.kinesisanalytics.model.KinesisAnalyticsException;
import software.amazon.awssdk.services.kinesisanalytics.model.RawInputRecordsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UnableToDetectSchemaException
extends KinesisAnalyticsException
implements ToCopyableBuilder<Builder, UnableToDetectSchemaException> {
    private final List<String> rawInputRecords;

    private UnableToDetectSchemaException(BuilderImpl builder) {
        super(builder.message);
        this.rawInputRecords = builder.rawInputRecords;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public List<String> rawInputRecords() {
        return this.rawInputRecords;
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> rawInputRecords;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(UnableToDetectSchemaException model) {
            this.setRawInputRecords(model.rawInputRecords);
            this.message = model.getMessage();
        }

        public final Collection<String> getRawInputRecords() {
            return this.rawInputRecords;
        }

        @Override
        public final Builder rawInputRecords(Collection<String> rawInputRecords) {
            this.rawInputRecords = RawInputRecordsCopier.copy(rawInputRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rawInputRecords(String ... rawInputRecords) {
            this.rawInputRecords(Arrays.asList(rawInputRecords));
            return this;
        }

        @JsonProperty(value="RawInputRecords")
        public final void setRawInputRecords(Collection<String> rawInputRecords) {
            this.rawInputRecords = RawInputRecordsCopier.copy(rawInputRecords);
        }

        public String getMessage() {
            return this.message;
        }

        public String message() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public UnableToDetectSchemaException build() {
            return new UnableToDetectSchemaException(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UnableToDetectSchemaException> {
        public Builder rawInputRecords(Collection<String> var1);

        public Builder rawInputRecords(String ... var1);

        public Builder message(String var1);
    }
}

