/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.CSVMappingParameters;
import software.amazon.awssdk.services.kinesisanalytics.model.JSONMappingParameters;
import software.amazon.awssdk.services.kinesisanalytics.transform.MappingParametersMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MappingParameters
implements StructuredPojo,
ToCopyableBuilder<Builder, MappingParameters> {
    private final JSONMappingParameters jsonMappingParameters;
    private final CSVMappingParameters csvMappingParameters;

    private MappingParameters(BuilderImpl builder) {
        this.jsonMappingParameters = builder.jsonMappingParameters;
        this.csvMappingParameters = builder.csvMappingParameters;
    }

    public JSONMappingParameters jsonMappingParameters() {
        return this.jsonMappingParameters;
    }

    public CSVMappingParameters csvMappingParameters() {
        return this.csvMappingParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.jsonMappingParameters() == null ? 0 : this.jsonMappingParameters().hashCode());
        hashCode = 31 * hashCode + (this.csvMappingParameters() == null ? 0 : this.csvMappingParameters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MappingParameters)) {
            return false;
        }
        MappingParameters other = (MappingParameters)obj;
        if (other.jsonMappingParameters() == null ^ this.jsonMappingParameters() == null) {
            return false;
        }
        if (other.jsonMappingParameters() != null && !other.jsonMappingParameters().equals(this.jsonMappingParameters())) {
            return false;
        }
        if (other.csvMappingParameters() == null ^ this.csvMappingParameters() == null) {
            return false;
        }
        return other.csvMappingParameters() == null || other.csvMappingParameters().equals(this.csvMappingParameters());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.jsonMappingParameters() != null) {
            sb.append("JSONMappingParameters: ").append(this.jsonMappingParameters()).append(",");
        }
        if (this.csvMappingParameters() != null) {
            sb.append("CSVMappingParameters: ").append(this.csvMappingParameters()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MappingParametersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private JSONMappingParameters jsonMappingParameters;
        private CSVMappingParameters csvMappingParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(MappingParameters model) {
            this.setJSONMappingParameters(model.jsonMappingParameters);
            this.setCSVMappingParameters(model.csvMappingParameters);
        }

        public final JSONMappingParameters getJSONMappingParameters() {
            return this.jsonMappingParameters;
        }

        @Override
        public final Builder jsonMappingParameters(JSONMappingParameters jsonMappingParameters) {
            this.jsonMappingParameters = jsonMappingParameters;
            return this;
        }

        public final void setJSONMappingParameters(JSONMappingParameters jsonMappingParameters) {
            this.jsonMappingParameters = jsonMappingParameters;
        }

        public final CSVMappingParameters getCSVMappingParameters() {
            return this.csvMappingParameters;
        }

        @Override
        public final Builder csvMappingParameters(CSVMappingParameters csvMappingParameters) {
            this.csvMappingParameters = csvMappingParameters;
            return this;
        }

        public final void setCSVMappingParameters(CSVMappingParameters csvMappingParameters) {
            this.csvMappingParameters = csvMappingParameters;
        }

        public MappingParameters build() {
            return new MappingParameters(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MappingParameters> {
        public Builder jsonMappingParameters(JSONMappingParameters var1);

        public Builder csvMappingParameters(CSVMappingParameters var1);
    }
}

