/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.kinesisanalytics.model.InputStartingPositionConfiguration;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DiscoverInputSchemaRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DiscoverInputSchemaRequest> {
    private final String resourceARN;
    private final String roleARN;
    private final InputStartingPositionConfiguration inputStartingPositionConfiguration;

    private DiscoverInputSchemaRequest(BuilderImpl builder) {
        this.resourceARN = builder.resourceARN;
        this.roleARN = builder.roleARN;
        this.inputStartingPositionConfiguration = builder.inputStartingPositionConfiguration;
    }

    public String resourceARN() {
        return this.resourceARN;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public InputStartingPositionConfiguration inputStartingPositionConfiguration() {
        return this.inputStartingPositionConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.resourceARN() == null ? 0 : this.resourceARN().hashCode());
        hashCode = 31 * hashCode + (this.roleARN() == null ? 0 : this.roleARN().hashCode());
        hashCode = 31 * hashCode + (this.inputStartingPositionConfiguration() == null ? 0 : this.inputStartingPositionConfiguration().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiscoverInputSchemaRequest)) {
            return false;
        }
        DiscoverInputSchemaRequest other = (DiscoverInputSchemaRequest)((Object)obj);
        if (other.resourceARN() == null ^ this.resourceARN() == null) {
            return false;
        }
        if (other.resourceARN() != null && !other.resourceARN().equals(this.resourceARN())) {
            return false;
        }
        if (other.roleARN() == null ^ this.roleARN() == null) {
            return false;
        }
        if (other.roleARN() != null && !other.roleARN().equals(this.roleARN())) {
            return false;
        }
        if (other.inputStartingPositionConfiguration() == null ^ this.inputStartingPositionConfiguration() == null) {
            return false;
        }
        return other.inputStartingPositionConfiguration() == null || other.inputStartingPositionConfiguration().equals(this.inputStartingPositionConfiguration());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.resourceARN() != null) {
            sb.append("ResourceARN: ").append(this.resourceARN()).append(",");
        }
        if (this.roleARN() != null) {
            sb.append("RoleARN: ").append(this.roleARN()).append(",");
        }
        if (this.inputStartingPositionConfiguration() != null) {
            sb.append("InputStartingPositionConfiguration: ").append(this.inputStartingPositionConfiguration()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String resourceARN;
        private String roleARN;
        private InputStartingPositionConfiguration inputStartingPositionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DiscoverInputSchemaRequest model) {
            this.setResourceARN(model.resourceARN);
            this.setRoleARN(model.roleARN);
            this.setInputStartingPositionConfiguration(model.inputStartingPositionConfiguration);
        }

        public final String getResourceARN() {
            return this.resourceARN;
        }

        @Override
        public final Builder resourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
            return this;
        }

        public final void setResourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final InputStartingPositionConfiguration getInputStartingPositionConfiguration() {
            return this.inputStartingPositionConfiguration;
        }

        @Override
        public final Builder inputStartingPositionConfiguration(InputStartingPositionConfiguration inputStartingPositionConfiguration) {
            this.inputStartingPositionConfiguration = inputStartingPositionConfiguration;
            return this;
        }

        public final void setInputStartingPositionConfiguration(InputStartingPositionConfiguration inputStartingPositionConfiguration) {
            this.inputStartingPositionConfiguration = inputStartingPositionConfiguration;
        }

        public DiscoverInputSchemaRequest build() {
            return new DiscoverInputSchemaRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DiscoverInputSchemaRequest> {
        public Builder resourceARN(String var1);

        public Builder roleARN(String var1);

        public Builder inputStartingPositionConfiguration(InputStartingPositionConfiguration var1);
    }
}

