/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.kinesis.model.PutRecordsResultEntry;
import software.amazon.awssdk.services.kinesis.model.PutRecordsResultEntryListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutRecordsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, PutRecordsResponse> {
    private final Integer failedRecordCount;
    private final List<PutRecordsResultEntry> records;

    private PutRecordsResponse(BuilderImpl builder) {
        this.failedRecordCount = builder.failedRecordCount;
        this.records = builder.records;
    }

    public Integer failedRecordCount() {
        return this.failedRecordCount;
    }

    public List<PutRecordsResultEntry> records() {
        return this.records;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.failedRecordCount() == null ? 0 : this.failedRecordCount().hashCode());
        hashCode = 31 * hashCode + (this.records() == null ? 0 : this.records().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecordsResponse)) {
            return false;
        }
        PutRecordsResponse other = (PutRecordsResponse)((Object)obj);
        if (other.failedRecordCount() == null ^ this.failedRecordCount() == null) {
            return false;
        }
        if (other.failedRecordCount() != null && !other.failedRecordCount().equals(this.failedRecordCount())) {
            return false;
        }
        if (other.records() == null ^ this.records() == null) {
            return false;
        }
        return other.records() == null || other.records().equals(this.records());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.failedRecordCount() != null) {
            sb.append("FailedRecordCount: ").append(this.failedRecordCount()).append(",");
        }
        if (this.records() != null) {
            sb.append("Records: ").append(this.records()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Integer failedRecordCount;
        private List<PutRecordsResultEntry> records;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRecordsResponse model) {
            this.setFailedRecordCount(model.failedRecordCount);
            this.setRecords(model.records);
        }

        public final Integer getFailedRecordCount() {
            return this.failedRecordCount;
        }

        @Override
        public final Builder failedRecordCount(Integer failedRecordCount) {
            this.failedRecordCount = failedRecordCount;
            return this;
        }

        public final void setFailedRecordCount(Integer failedRecordCount) {
            this.failedRecordCount = failedRecordCount;
        }

        public final Collection<PutRecordsResultEntry> getRecords() {
            return this.records;
        }

        @Override
        public final Builder records(Collection<PutRecordsResultEntry> records) {
            this.records = PutRecordsResultEntryListCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(PutRecordsResultEntry ... records) {
            this.records(Arrays.asList(records));
            return this;
        }

        public final void setRecords(Collection<PutRecordsResultEntry> records) {
            this.records = PutRecordsResultEntryListCopier.copy(records);
        }

        public PutRecordsResponse build() {
            return new PutRecordsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutRecordsResponse> {
        public Builder failedRecordCount(Integer var1);

        public Builder records(Collection<PutRecordsResultEntry> var1);

        public Builder records(PutRecordsResultEntry ... var1);
    }
}

