/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.model.Processor;
import software.amazon.awssdk.services.firehose.model.ProcessorListCopier;
import software.amazon.awssdk.services.firehose.transform.ProcessingConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ProcessingConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, ProcessingConfiguration> {
    private final Boolean enabled;
    private final List<Processor> processors;

    private ProcessingConfiguration(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.processors = builder.processors;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public List<Processor> processors() {
        return this.processors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.enabled() == null ? 0 : this.enabled().hashCode());
        hashCode = 31 * hashCode + (this.processors() == null ? 0 : this.processors().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcessingConfiguration)) {
            return false;
        }
        ProcessingConfiguration other = (ProcessingConfiguration)obj;
        if (other.enabled() == null ^ this.enabled() == null) {
            return false;
        }
        if (other.enabled() != null && !other.enabled().equals(this.enabled())) {
            return false;
        }
        if (other.processors() == null ^ this.processors() == null) {
            return false;
        }
        return other.processors() == null || other.processors().equals(this.processors());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.enabled() != null) {
            sb.append("Enabled: ").append(this.enabled()).append(",");
        }
        if (this.processors() != null) {
            sb.append("Processors: ").append(this.processors()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProcessingConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private List<Processor> processors;

        private BuilderImpl() {
        }

        private BuilderImpl(ProcessingConfiguration model) {
            this.setEnabled(model.enabled);
            this.setProcessors(model.processors);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Collection<Processor> getProcessors() {
            return this.processors;
        }

        @Override
        public final Builder processors(Collection<Processor> processors) {
            this.processors = ProcessorListCopier.copy(processors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processors(Processor ... processors) {
            this.processors(Arrays.asList(processors));
            return this;
        }

        public final void setProcessors(Collection<Processor> processors) {
            this.processors = ProcessorListCopier.copy(processors);
        }

        public ProcessingConfiguration build() {
            return new ProcessingConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ProcessingConfiguration> {
        public Builder enabled(Boolean var1);

        public Builder processors(Collection<Processor> var1);

        public Builder processors(Processor ... var1);
    }
}

