/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.kinesis.model.HashKeyRange;

public class HashKeyRangeUnmarshaller
implements Unmarshaller<HashKeyRange, JsonUnmarshallerContext> {
    private static HashKeyRangeUnmarshaller INSTANCE;

    public HashKeyRange unmarshall(JsonUnmarshallerContext context) throws Exception {
        HashKeyRange.Builder hashKeyRangeBuilder = HashKeyRange.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("StartingHashKey", targetDepth)) {
                    context.nextToken();
                    hashKeyRangeBuilder.startingHashKey((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("EndingHashKey", targetDepth)) {
                    context.nextToken();
                    hashKeyRangeBuilder.endingHashKey((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (HashKeyRange)hashKeyRangeBuilder.build();
    }

    public static HashKeyRangeUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new HashKeyRangeUnmarshaller();
        }
        return INSTANCE;
    }
}

