/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesis.model.EnhancedMetrics;
import software.amazon.awssdk.services.kinesis.model.EnhancedMonitoringListCopier;
import software.amazon.awssdk.services.kinesis.model.Shard;
import software.amazon.awssdk.services.kinesis.model.ShardListCopier;
import software.amazon.awssdk.services.kinesis.model.StreamStatus;
import software.amazon.awssdk.services.kinesis.transform.StreamDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StreamDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, StreamDescription> {
    private final String streamName;
    private final String streamARN;
    private final String streamStatus;
    private final List<Shard> shards;
    private final Boolean hasMoreShards;
    private final Integer retentionPeriodHours;
    private final Instant streamCreationTimestamp;
    private final List<EnhancedMetrics> enhancedMonitoring;

    private StreamDescription(BuilderImpl builder) {
        this.streamName = builder.streamName;
        this.streamARN = builder.streamARN;
        this.streamStatus = builder.streamStatus;
        this.shards = builder.shards;
        this.hasMoreShards = builder.hasMoreShards;
        this.retentionPeriodHours = builder.retentionPeriodHours;
        this.streamCreationTimestamp = builder.streamCreationTimestamp;
        this.enhancedMonitoring = builder.enhancedMonitoring;
    }

    public String streamName() {
        return this.streamName;
    }

    public String streamARN() {
        return this.streamARN;
    }

    public String streamStatus() {
        return this.streamStatus;
    }

    public List<Shard> shards() {
        return this.shards;
    }

    public Boolean hasMoreShards() {
        return this.hasMoreShards;
    }

    public Integer retentionPeriodHours() {
        return this.retentionPeriodHours;
    }

    public Instant streamCreationTimestamp() {
        return this.streamCreationTimestamp;
    }

    public List<EnhancedMetrics> enhancedMonitoring() {
        return this.enhancedMonitoring;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.streamName() == null ? 0 : this.streamName().hashCode());
        hashCode = 31 * hashCode + (this.streamARN() == null ? 0 : this.streamARN().hashCode());
        hashCode = 31 * hashCode + (this.streamStatus() == null ? 0 : this.streamStatus().hashCode());
        hashCode = 31 * hashCode + (this.shards() == null ? 0 : this.shards().hashCode());
        hashCode = 31 * hashCode + (this.hasMoreShards() == null ? 0 : this.hasMoreShards().hashCode());
        hashCode = 31 * hashCode + (this.retentionPeriodHours() == null ? 0 : this.retentionPeriodHours().hashCode());
        hashCode = 31 * hashCode + (this.streamCreationTimestamp() == null ? 0 : this.streamCreationTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.enhancedMonitoring() == null ? 0 : this.enhancedMonitoring().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamDescription)) {
            return false;
        }
        StreamDescription other = (StreamDescription)obj;
        if (other.streamName() == null ^ this.streamName() == null) {
            return false;
        }
        if (other.streamName() != null && !other.streamName().equals(this.streamName())) {
            return false;
        }
        if (other.streamARN() == null ^ this.streamARN() == null) {
            return false;
        }
        if (other.streamARN() != null && !other.streamARN().equals(this.streamARN())) {
            return false;
        }
        if (other.streamStatus() == null ^ this.streamStatus() == null) {
            return false;
        }
        if (other.streamStatus() != null && !other.streamStatus().equals(this.streamStatus())) {
            return false;
        }
        if (other.shards() == null ^ this.shards() == null) {
            return false;
        }
        if (other.shards() != null && !other.shards().equals(this.shards())) {
            return false;
        }
        if (other.hasMoreShards() == null ^ this.hasMoreShards() == null) {
            return false;
        }
        if (other.hasMoreShards() != null && !other.hasMoreShards().equals(this.hasMoreShards())) {
            return false;
        }
        if (other.retentionPeriodHours() == null ^ this.retentionPeriodHours() == null) {
            return false;
        }
        if (other.retentionPeriodHours() != null && !other.retentionPeriodHours().equals(this.retentionPeriodHours())) {
            return false;
        }
        if (other.streamCreationTimestamp() == null ^ this.streamCreationTimestamp() == null) {
            return false;
        }
        if (other.streamCreationTimestamp() != null && !other.streamCreationTimestamp().equals(this.streamCreationTimestamp())) {
            return false;
        }
        if (other.enhancedMonitoring() == null ^ this.enhancedMonitoring() == null) {
            return false;
        }
        return other.enhancedMonitoring() == null || other.enhancedMonitoring().equals(this.enhancedMonitoring());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.streamName() != null) {
            sb.append("StreamName: ").append(this.streamName()).append(",");
        }
        if (this.streamARN() != null) {
            sb.append("StreamARN: ").append(this.streamARN()).append(",");
        }
        if (this.streamStatus() != null) {
            sb.append("StreamStatus: ").append(this.streamStatus()).append(",");
        }
        if (this.shards() != null) {
            sb.append("Shards: ").append(this.shards()).append(",");
        }
        if (this.hasMoreShards() != null) {
            sb.append("HasMoreShards: ").append(this.hasMoreShards()).append(",");
        }
        if (this.retentionPeriodHours() != null) {
            sb.append("RetentionPeriodHours: ").append(this.retentionPeriodHours()).append(",");
        }
        if (this.streamCreationTimestamp() != null) {
            sb.append("StreamCreationTimestamp: ").append(this.streamCreationTimestamp()).append(",");
        }
        if (this.enhancedMonitoring() != null) {
            sb.append("EnhancedMonitoring: ").append(this.enhancedMonitoring()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StreamDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String streamName;
        private String streamARN;
        private String streamStatus;
        private List<Shard> shards;
        private Boolean hasMoreShards;
        private Integer retentionPeriodHours;
        private Instant streamCreationTimestamp;
        private List<EnhancedMetrics> enhancedMonitoring;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamDescription model) {
            this.setStreamName(model.streamName);
            this.setStreamARN(model.streamARN);
            this.setStreamStatus(model.streamStatus);
            this.setShards(model.shards);
            this.setHasMoreShards(model.hasMoreShards);
            this.setRetentionPeriodHours(model.retentionPeriodHours);
            this.setStreamCreationTimestamp(model.streamCreationTimestamp);
            this.setEnhancedMonitoring(model.enhancedMonitoring);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final String getStreamARN() {
            return this.streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        public final String getStreamStatus() {
            return this.streamStatus;
        }

        @Override
        public final Builder streamStatus(String streamStatus) {
            this.streamStatus = streamStatus;
            return this;
        }

        @Override
        public final Builder streamStatus(StreamStatus streamStatus) {
            this.streamStatus(streamStatus.toString());
            return this;
        }

        public final void setStreamStatus(String streamStatus) {
            this.streamStatus = streamStatus;
        }

        public final void setStreamStatus(StreamStatus streamStatus) {
            this.streamStatus(streamStatus.toString());
        }

        public final Collection<Shard> getShards() {
            return this.shards;
        }

        @Override
        public final Builder shards(Collection<Shard> shards) {
            this.shards = ShardListCopier.copy(shards);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shards(Shard ... shards) {
            this.shards(Arrays.asList(shards));
            return this;
        }

        public final void setShards(Collection<Shard> shards) {
            this.shards = ShardListCopier.copy(shards);
        }

        @SafeVarargs
        public final void setShards(Shard ... shards) {
            this.shards(Arrays.asList(shards));
        }

        public final Boolean getHasMoreShards() {
            return this.hasMoreShards;
        }

        @Override
        public final Builder hasMoreShards(Boolean hasMoreShards) {
            this.hasMoreShards = hasMoreShards;
            return this;
        }

        public final void setHasMoreShards(Boolean hasMoreShards) {
            this.hasMoreShards = hasMoreShards;
        }

        public final Integer getRetentionPeriodHours() {
            return this.retentionPeriodHours;
        }

        @Override
        public final Builder retentionPeriodHours(Integer retentionPeriodHours) {
            this.retentionPeriodHours = retentionPeriodHours;
            return this;
        }

        public final void setRetentionPeriodHours(Integer retentionPeriodHours) {
            this.retentionPeriodHours = retentionPeriodHours;
        }

        public final Instant getStreamCreationTimestamp() {
            return this.streamCreationTimestamp;
        }

        @Override
        public final Builder streamCreationTimestamp(Instant streamCreationTimestamp) {
            this.streamCreationTimestamp = streamCreationTimestamp;
            return this;
        }

        public final void setStreamCreationTimestamp(Instant streamCreationTimestamp) {
            this.streamCreationTimestamp = streamCreationTimestamp;
        }

        public final Collection<EnhancedMetrics> getEnhancedMonitoring() {
            return this.enhancedMonitoring;
        }

        @Override
        public final Builder enhancedMonitoring(Collection<EnhancedMetrics> enhancedMonitoring) {
            this.enhancedMonitoring = EnhancedMonitoringListCopier.copy(enhancedMonitoring);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enhancedMonitoring(EnhancedMetrics ... enhancedMonitoring) {
            this.enhancedMonitoring(Arrays.asList(enhancedMonitoring));
            return this;
        }

        public final void setEnhancedMonitoring(Collection<EnhancedMetrics> enhancedMonitoring) {
            this.enhancedMonitoring = EnhancedMonitoringListCopier.copy(enhancedMonitoring);
        }

        @SafeVarargs
        public final void setEnhancedMonitoring(EnhancedMetrics ... enhancedMonitoring) {
            this.enhancedMonitoring(Arrays.asList(enhancedMonitoring));
        }

        public StreamDescription build() {
            return new StreamDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StreamDescription> {
        public Builder streamName(String var1);

        public Builder streamARN(String var1);

        public Builder streamStatus(String var1);

        public Builder streamStatus(StreamStatus var1);

        public Builder shards(Collection<Shard> var1);

        public Builder shards(Shard ... var1);

        public Builder hasMoreShards(Boolean var1);

        public Builder retentionPeriodHours(Integer var1);

        public Builder streamCreationTimestamp(Instant var1);

        public Builder enhancedMonitoring(Collection<EnhancedMetrics> var1);

        public Builder enhancedMonitoring(EnhancedMetrics ... var1);
    }
}

