/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.kinesis.model.MetricsName;
import software.amazon.awssdk.services.kinesis.model.MetricsNameListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DisableEnhancedMonitoringResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DisableEnhancedMonitoringResponse> {
    private final String streamName;
    private final List<String> currentShardLevelMetrics;
    private final List<String> desiredShardLevelMetrics;

    private DisableEnhancedMonitoringResponse(BuilderImpl builder) {
        this.streamName = builder.streamName;
        this.currentShardLevelMetrics = builder.currentShardLevelMetrics;
        this.desiredShardLevelMetrics = builder.desiredShardLevelMetrics;
    }

    public String streamName() {
        return this.streamName;
    }

    public List<String> currentShardLevelMetrics() {
        return this.currentShardLevelMetrics;
    }

    public List<String> desiredShardLevelMetrics() {
        return this.desiredShardLevelMetrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.streamName() == null ? 0 : this.streamName().hashCode());
        hashCode = 31 * hashCode + (this.currentShardLevelMetrics() == null ? 0 : this.currentShardLevelMetrics().hashCode());
        hashCode = 31 * hashCode + (this.desiredShardLevelMetrics() == null ? 0 : this.desiredShardLevelMetrics().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisableEnhancedMonitoringResponse)) {
            return false;
        }
        DisableEnhancedMonitoringResponse other = (DisableEnhancedMonitoringResponse)((Object)obj);
        if (other.streamName() == null ^ this.streamName() == null) {
            return false;
        }
        if (other.streamName() != null && !other.streamName().equals(this.streamName())) {
            return false;
        }
        if (other.currentShardLevelMetrics() == null ^ this.currentShardLevelMetrics() == null) {
            return false;
        }
        if (other.currentShardLevelMetrics() != null && !other.currentShardLevelMetrics().equals(this.currentShardLevelMetrics())) {
            return false;
        }
        if (other.desiredShardLevelMetrics() == null ^ this.desiredShardLevelMetrics() == null) {
            return false;
        }
        return other.desiredShardLevelMetrics() == null || other.desiredShardLevelMetrics().equals(this.desiredShardLevelMetrics());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.streamName() != null) {
            sb.append("StreamName: ").append(this.streamName()).append(",");
        }
        if (this.currentShardLevelMetrics() != null) {
            sb.append("CurrentShardLevelMetrics: ").append(this.currentShardLevelMetrics()).append(",");
        }
        if (this.desiredShardLevelMetrics() != null) {
            sb.append("DesiredShardLevelMetrics: ").append(this.desiredShardLevelMetrics()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String streamName;
        private List<String> currentShardLevelMetrics;
        private List<String> desiredShardLevelMetrics;

        private BuilderImpl() {
        }

        private BuilderImpl(DisableEnhancedMonitoringResponse model) {
            this.setStreamName(model.streamName);
            this.setCurrentShardLevelMetrics(model.currentShardLevelMetrics);
            this.setDesiredShardLevelMetrics(model.desiredShardLevelMetrics);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final Collection<String> getCurrentShardLevelMetrics() {
            return this.currentShardLevelMetrics;
        }

        @Override
        public final Builder currentShardLevelMetrics(Collection<String> currentShardLevelMetrics) {
            this.currentShardLevelMetrics = MetricsNameListCopier.copy(currentShardLevelMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder currentShardLevelMetrics(String ... currentShardLevelMetrics) {
            this.currentShardLevelMetrics(Arrays.asList(currentShardLevelMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder currentShardLevelMetrics(MetricsName ... currentShardLevelMetrics) {
            this.currentShardLevelMetrics(Arrays.asList(currentShardLevelMetrics).stream().map(Object::toString).collect(Collectors.toList()));
            return this;
        }

        public final void setCurrentShardLevelMetrics(Collection<String> currentShardLevelMetrics) {
            this.currentShardLevelMetrics = MetricsNameListCopier.copy(currentShardLevelMetrics);
        }

        @SafeVarargs
        public final void setCurrentShardLevelMetrics(String ... currentShardLevelMetrics) {
            this.currentShardLevelMetrics(Arrays.asList(currentShardLevelMetrics));
        }

        @SafeVarargs
        public final void setCurrentShardLevelMetrics(MetricsName ... currentShardLevelMetrics) {
            this.currentShardLevelMetrics(Arrays.asList(currentShardLevelMetrics).stream().map(Object::toString).collect(Collectors.toList()));
        }

        public final Collection<String> getDesiredShardLevelMetrics() {
            return this.desiredShardLevelMetrics;
        }

        @Override
        public final Builder desiredShardLevelMetrics(Collection<String> desiredShardLevelMetrics) {
            this.desiredShardLevelMetrics = MetricsNameListCopier.copy(desiredShardLevelMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder desiredShardLevelMetrics(String ... desiredShardLevelMetrics) {
            this.desiredShardLevelMetrics(Arrays.asList(desiredShardLevelMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder desiredShardLevelMetrics(MetricsName ... desiredShardLevelMetrics) {
            this.desiredShardLevelMetrics(Arrays.asList(desiredShardLevelMetrics).stream().map(Object::toString).collect(Collectors.toList()));
            return this;
        }

        public final void setDesiredShardLevelMetrics(Collection<String> desiredShardLevelMetrics) {
            this.desiredShardLevelMetrics = MetricsNameListCopier.copy(desiredShardLevelMetrics);
        }

        @SafeVarargs
        public final void setDesiredShardLevelMetrics(String ... desiredShardLevelMetrics) {
            this.desiredShardLevelMetrics(Arrays.asList(desiredShardLevelMetrics));
        }

        @SafeVarargs
        public final void setDesiredShardLevelMetrics(MetricsName ... desiredShardLevelMetrics) {
            this.desiredShardLevelMetrics(Arrays.asList(desiredShardLevelMetrics).stream().map(Object::toString).collect(Collectors.toList()));
        }

        public DisableEnhancedMonitoringResponse build() {
            return new DisableEnhancedMonitoringResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DisableEnhancedMonitoringResponse> {
        public Builder streamName(String var1);

        public Builder currentShardLevelMetrics(Collection<String> var1);

        public Builder currentShardLevelMetrics(String ... var1);

        public Builder currentShardLevelMetrics(MetricsName ... var1);

        public Builder desiredShardLevelMetrics(Collection<String> var1);

        public Builder desiredShardLevelMetrics(String ... var1);

        public Builder desiredShardLevelMetrics(MetricsName ... var1);
    }
}

