/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesisanalytics.model.S3ReferenceDataSourceUpdate;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class S3ReferenceDataSourceUpdateMarshaller {
    private static final MarshallingInfo<String> BUCKETARNUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BucketARNUpdate").isBinary(false).build();
    private static final MarshallingInfo<String> FILEKEYUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FileKeyUpdate").isBinary(false).build();
    private static final MarshallingInfo<String> REFERENCEROLEARNUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReferenceRoleARNUpdate").isBinary(false).build();
    private static final S3ReferenceDataSourceUpdateMarshaller INSTANCE = new S3ReferenceDataSourceUpdateMarshaller();

    private S3ReferenceDataSourceUpdateMarshaller() {
    }

    public static S3ReferenceDataSourceUpdateMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(S3ReferenceDataSourceUpdate s3ReferenceDataSourceUpdate, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)s3ReferenceDataSourceUpdate, (String)"s3ReferenceDataSourceUpdate");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)s3ReferenceDataSourceUpdate.bucketARNUpdate(), BUCKETARNUPDATE_BINDING);
            protocolMarshaller.marshall((Object)s3ReferenceDataSourceUpdate.fileKeyUpdate(), FILEKEYUPDATE_BINDING);
            protocolMarshaller.marshall((Object)s3ReferenceDataSourceUpdate.referenceRoleARNUpdate(), REFERENCEROLEARNUPDATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

