/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.kinesisanalytics.model.ApplicationSummariesCopier;
import software.amazon.awssdk.services.kinesisanalytics.model.ApplicationSummary;
import software.amazon.awssdk.services.kinesisanalytics.model.KinesisAnalyticsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListApplicationsResponse
extends KinesisAnalyticsResponse
implements ToCopyableBuilder<Builder, ListApplicationsResponse> {
    private final List<ApplicationSummary> applicationSummaries;
    private final Boolean hasMoreApplications;

    private ListApplicationsResponse(BuilderImpl builder) {
        super(builder);
        this.applicationSummaries = builder.applicationSummaries;
        this.hasMoreApplications = builder.hasMoreApplications;
    }

    public List<ApplicationSummary> applicationSummaries() {
        return this.applicationSummaries;
    }

    public Boolean hasMoreApplications() {
        return this.hasMoreApplications;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMoreApplications());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationsResponse)) {
            return false;
        }
        ListApplicationsResponse other = (ListApplicationsResponse)((Object)obj);
        return Objects.equals(this.applicationSummaries(), other.applicationSummaries()) && Objects.equals(this.hasMoreApplications(), other.hasMoreApplications());
    }

    public String toString() {
        return ToString.builder((String)"ListApplicationsResponse").add("ApplicationSummaries", this.applicationSummaries()).add("HasMoreApplications", (Object)this.hasMoreApplications()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationSummaries": {
                return Optional.of(clazz.cast(this.applicationSummaries()));
            }
            case "HasMoreApplications": {
                return Optional.of(clazz.cast(this.hasMoreApplications()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends KinesisAnalyticsResponse.BuilderImpl
    implements Builder {
        private List<ApplicationSummary> applicationSummaries;
        private Boolean hasMoreApplications;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationsResponse model) {
            super(model);
            this.applicationSummaries(model.applicationSummaries);
            this.hasMoreApplications(model.hasMoreApplications);
        }

        public final Collection<ApplicationSummary.Builder> getApplicationSummaries() {
            return this.applicationSummaries != null ? (Collection)this.applicationSummaries.stream().map(ApplicationSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder applicationSummaries(Collection<ApplicationSummary> applicationSummaries) {
            this.applicationSummaries = ApplicationSummariesCopier.copy(applicationSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationSummaries(ApplicationSummary ... applicationSummaries) {
            this.applicationSummaries(Arrays.asList(applicationSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationSummaries(Consumer<ApplicationSummary.Builder> ... applicationSummaries) {
            this.applicationSummaries(Stream.of(applicationSummaries).map(c -> (ApplicationSummary)((ApplicationSummary.Builder)ApplicationSummary.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setApplicationSummaries(Collection<ApplicationSummary.BuilderImpl> applicationSummaries) {
            this.applicationSummaries = ApplicationSummariesCopier.copyFromBuilder(applicationSummaries);
        }

        public final Boolean getHasMoreApplications() {
            return this.hasMoreApplications;
        }

        @Override
        public final Builder hasMoreApplications(Boolean hasMoreApplications) {
            this.hasMoreApplications = hasMoreApplications;
            return this;
        }

        public final void setHasMoreApplications(Boolean hasMoreApplications) {
            this.hasMoreApplications = hasMoreApplications;
        }

        @Override
        public ListApplicationsResponse build() {
            return new ListApplicationsResponse(this);
        }
    }

    public static interface Builder
    extends KinesisAnalyticsResponse.Builder,
    CopyableBuilder<Builder, ListApplicationsResponse> {
        public Builder applicationSummaries(Collection<ApplicationSummary> var1);

        public Builder applicationSummaries(ApplicationSummary ... var1);

        public Builder applicationSummaries(Consumer<ApplicationSummary.Builder> ... var1);

        public Builder hasMoreApplications(Boolean var1);
    }
}

