/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus;
import software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOptionDescription;
import software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOptionDescriptionsCopier;
import software.amazon.awssdk.services.kinesisanalytics.model.InputDescription;
import software.amazon.awssdk.services.kinesisanalytics.model.InputDescriptionsCopier;
import software.amazon.awssdk.services.kinesisanalytics.model.OutputDescription;
import software.amazon.awssdk.services.kinesisanalytics.model.OutputDescriptionsCopier;
import software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSourceDescription;
import software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSourceDescriptionsCopier;
import software.amazon.awssdk.services.kinesisanalytics.transform.ApplicationDetailMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ApplicationDetail
implements StructuredPojo,
ToCopyableBuilder<Builder, ApplicationDetail> {
    private final String applicationName;
    private final String applicationDescription;
    private final String applicationARN;
    private final String applicationStatus;
    private final Instant createTimestamp;
    private final Instant lastUpdateTimestamp;
    private final List<InputDescription> inputDescriptions;
    private final List<OutputDescription> outputDescriptions;
    private final List<ReferenceDataSourceDescription> referenceDataSourceDescriptions;
    private final List<CloudWatchLoggingOptionDescription> cloudWatchLoggingOptionDescriptions;
    private final String applicationCode;
    private final Long applicationVersionId;

    private ApplicationDetail(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.applicationDescription = builder.applicationDescription;
        this.applicationARN = builder.applicationARN;
        this.applicationStatus = builder.applicationStatus;
        this.createTimestamp = builder.createTimestamp;
        this.lastUpdateTimestamp = builder.lastUpdateTimestamp;
        this.inputDescriptions = builder.inputDescriptions;
        this.outputDescriptions = builder.outputDescriptions;
        this.referenceDataSourceDescriptions = builder.referenceDataSourceDescriptions;
        this.cloudWatchLoggingOptionDescriptions = builder.cloudWatchLoggingOptionDescriptions;
        this.applicationCode = builder.applicationCode;
        this.applicationVersionId = builder.applicationVersionId;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String applicationDescription() {
        return this.applicationDescription;
    }

    public String applicationARN() {
        return this.applicationARN;
    }

    public ApplicationStatus applicationStatus() {
        return ApplicationStatus.fromValue(this.applicationStatus);
    }

    public String applicationStatusAsString() {
        return this.applicationStatus;
    }

    public Instant createTimestamp() {
        return this.createTimestamp;
    }

    public Instant lastUpdateTimestamp() {
        return this.lastUpdateTimestamp;
    }

    public List<InputDescription> inputDescriptions() {
        return this.inputDescriptions;
    }

    public List<OutputDescription> outputDescriptions() {
        return this.outputDescriptions;
    }

    public List<ReferenceDataSourceDescription> referenceDataSourceDescriptions() {
        return this.referenceDataSourceDescriptions;
    }

    public List<CloudWatchLoggingOptionDescription> cloudWatchLoggingOptionDescriptions() {
        return this.cloudWatchLoggingOptionDescriptions;
    }

    public String applicationCode() {
        return this.applicationCode;
    }

    public Long applicationVersionId() {
        return this.applicationVersionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputDescriptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputDescriptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.referenceDataSourceDescriptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLoggingOptionDescriptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationVersionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationDetail)) {
            return false;
        }
        ApplicationDetail other = (ApplicationDetail)obj;
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.applicationDescription(), other.applicationDescription()) && Objects.equals(this.applicationARN(), other.applicationARN()) && Objects.equals(this.applicationStatusAsString(), other.applicationStatusAsString()) && Objects.equals(this.createTimestamp(), other.createTimestamp()) && Objects.equals(this.lastUpdateTimestamp(), other.lastUpdateTimestamp()) && Objects.equals(this.inputDescriptions(), other.inputDescriptions()) && Objects.equals(this.outputDescriptions(), other.outputDescriptions()) && Objects.equals(this.referenceDataSourceDescriptions(), other.referenceDataSourceDescriptions()) && Objects.equals(this.cloudWatchLoggingOptionDescriptions(), other.cloudWatchLoggingOptionDescriptions()) && Objects.equals(this.applicationCode(), other.applicationCode()) && Objects.equals(this.applicationVersionId(), other.applicationVersionId());
    }

    public String toString() {
        return ToString.builder((String)"ApplicationDetail").add("ApplicationName", (Object)this.applicationName()).add("ApplicationDescription", (Object)this.applicationDescription()).add("ApplicationARN", (Object)this.applicationARN()).add("ApplicationStatus", (Object)this.applicationStatusAsString()).add("CreateTimestamp", (Object)this.createTimestamp()).add("LastUpdateTimestamp", (Object)this.lastUpdateTimestamp()).add("InputDescriptions", this.inputDescriptions()).add("OutputDescriptions", this.outputDescriptions()).add("ReferenceDataSourceDescriptions", this.referenceDataSourceDescriptions()).add("CloudWatchLoggingOptionDescriptions", this.cloudWatchLoggingOptionDescriptions()).add("ApplicationCode", (Object)this.applicationCode()).add("ApplicationVersionId", (Object)this.applicationVersionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.of(clazz.cast(this.applicationName()));
            }
            case "ApplicationDescription": {
                return Optional.of(clazz.cast(this.applicationDescription()));
            }
            case "ApplicationARN": {
                return Optional.of(clazz.cast(this.applicationARN()));
            }
            case "ApplicationStatus": {
                return Optional.of(clazz.cast(this.applicationStatusAsString()));
            }
            case "CreateTimestamp": {
                return Optional.of(clazz.cast(this.createTimestamp()));
            }
            case "LastUpdateTimestamp": {
                return Optional.of(clazz.cast(this.lastUpdateTimestamp()));
            }
            case "InputDescriptions": {
                return Optional.of(clazz.cast(this.inputDescriptions()));
            }
            case "OutputDescriptions": {
                return Optional.of(clazz.cast(this.outputDescriptions()));
            }
            case "ReferenceDataSourceDescriptions": {
                return Optional.of(clazz.cast(this.referenceDataSourceDescriptions()));
            }
            case "CloudWatchLoggingOptionDescriptions": {
                return Optional.of(clazz.cast(this.cloudWatchLoggingOptionDescriptions()));
            }
            case "ApplicationCode": {
                return Optional.of(clazz.cast(this.applicationCode()));
            }
            case "ApplicationVersionId": {
                return Optional.of(clazz.cast(this.applicationVersionId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ApplicationDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private String applicationDescription;
        private String applicationARN;
        private String applicationStatus;
        private Instant createTimestamp;
        private Instant lastUpdateTimestamp;
        private List<InputDescription> inputDescriptions;
        private List<OutputDescription> outputDescriptions;
        private List<ReferenceDataSourceDescription> referenceDataSourceDescriptions;
        private List<CloudWatchLoggingOptionDescription> cloudWatchLoggingOptionDescriptions;
        private String applicationCode;
        private Long applicationVersionId;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationDetail model) {
            this.applicationName(model.applicationName);
            this.applicationDescription(model.applicationDescription);
            this.applicationARN(model.applicationARN);
            this.applicationStatus(model.applicationStatus);
            this.createTimestamp(model.createTimestamp);
            this.lastUpdateTimestamp(model.lastUpdateTimestamp);
            this.inputDescriptions(model.inputDescriptions);
            this.outputDescriptions(model.outputDescriptions);
            this.referenceDataSourceDescriptions(model.referenceDataSourceDescriptions);
            this.cloudWatchLoggingOptionDescriptions(model.cloudWatchLoggingOptionDescriptions);
            this.applicationCode(model.applicationCode);
            this.applicationVersionId(model.applicationVersionId);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getApplicationDescription() {
            return this.applicationDescription;
        }

        @Override
        public final Builder applicationDescription(String applicationDescription) {
            this.applicationDescription = applicationDescription;
            return this;
        }

        public final void setApplicationDescription(String applicationDescription) {
            this.applicationDescription = applicationDescription;
        }

        public final String getApplicationARN() {
            return this.applicationARN;
        }

        @Override
        public final Builder applicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
            return this;
        }

        public final void setApplicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
        }

        public final String getApplicationStatus() {
            return this.applicationStatus;
        }

        @Override
        public final Builder applicationStatus(String applicationStatus) {
            this.applicationStatus = applicationStatus;
            return this;
        }

        @Override
        public final Builder applicationStatus(ApplicationStatus applicationStatus) {
            this.applicationStatus(applicationStatus.toString());
            return this;
        }

        public final void setApplicationStatus(String applicationStatus) {
            this.applicationStatus = applicationStatus;
        }

        public final Instant getCreateTimestamp() {
            return this.createTimestamp;
        }

        @Override
        public final Builder createTimestamp(Instant createTimestamp) {
            this.createTimestamp = createTimestamp;
            return this;
        }

        public final void setCreateTimestamp(Instant createTimestamp) {
            this.createTimestamp = createTimestamp;
        }

        public final Instant getLastUpdateTimestamp() {
            return this.lastUpdateTimestamp;
        }

        @Override
        public final Builder lastUpdateTimestamp(Instant lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
            return this;
        }

        public final void setLastUpdateTimestamp(Instant lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
        }

        public final Collection<InputDescription.Builder> getInputDescriptions() {
            return this.inputDescriptions != null ? (Collection)this.inputDescriptions.stream().map(InputDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inputDescriptions(Collection<InputDescription> inputDescriptions) {
            this.inputDescriptions = InputDescriptionsCopier.copy(inputDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDescriptions(InputDescription ... inputDescriptions) {
            this.inputDescriptions(Arrays.asList(inputDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDescriptions(Consumer<InputDescription.Builder> ... inputDescriptions) {
            this.inputDescriptions(Stream.of(inputDescriptions).map(c -> (InputDescription)((InputDescription.Builder)InputDescription.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInputDescriptions(Collection<InputDescription.BuilderImpl> inputDescriptions) {
            this.inputDescriptions = InputDescriptionsCopier.copyFromBuilder(inputDescriptions);
        }

        public final Collection<OutputDescription.Builder> getOutputDescriptions() {
            return this.outputDescriptions != null ? (Collection)this.outputDescriptions.stream().map(OutputDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder outputDescriptions(Collection<OutputDescription> outputDescriptions) {
            this.outputDescriptions = OutputDescriptionsCopier.copy(outputDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputDescriptions(OutputDescription ... outputDescriptions) {
            this.outputDescriptions(Arrays.asList(outputDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputDescriptions(Consumer<OutputDescription.Builder> ... outputDescriptions) {
            this.outputDescriptions(Stream.of(outputDescriptions).map(c -> (OutputDescription)((OutputDescription.Builder)OutputDescription.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOutputDescriptions(Collection<OutputDescription.BuilderImpl> outputDescriptions) {
            this.outputDescriptions = OutputDescriptionsCopier.copyFromBuilder(outputDescriptions);
        }

        public final Collection<ReferenceDataSourceDescription.Builder> getReferenceDataSourceDescriptions() {
            return this.referenceDataSourceDescriptions != null ? (Collection)this.referenceDataSourceDescriptions.stream().map(ReferenceDataSourceDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder referenceDataSourceDescriptions(Collection<ReferenceDataSourceDescription> referenceDataSourceDescriptions) {
            this.referenceDataSourceDescriptions = ReferenceDataSourceDescriptionsCopier.copy(referenceDataSourceDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceDataSourceDescriptions(ReferenceDataSourceDescription ... referenceDataSourceDescriptions) {
            this.referenceDataSourceDescriptions(Arrays.asList(referenceDataSourceDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceDataSourceDescriptions(Consumer<ReferenceDataSourceDescription.Builder> ... referenceDataSourceDescriptions) {
            this.referenceDataSourceDescriptions(Stream.of(referenceDataSourceDescriptions).map(c -> (ReferenceDataSourceDescription)((ReferenceDataSourceDescription.Builder)ReferenceDataSourceDescription.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReferenceDataSourceDescriptions(Collection<ReferenceDataSourceDescription.BuilderImpl> referenceDataSourceDescriptions) {
            this.referenceDataSourceDescriptions = ReferenceDataSourceDescriptionsCopier.copyFromBuilder(referenceDataSourceDescriptions);
        }

        public final Collection<CloudWatchLoggingOptionDescription.Builder> getCloudWatchLoggingOptionDescriptions() {
            return this.cloudWatchLoggingOptionDescriptions != null ? (Collection)this.cloudWatchLoggingOptionDescriptions.stream().map(CloudWatchLoggingOptionDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cloudWatchLoggingOptionDescriptions(Collection<CloudWatchLoggingOptionDescription> cloudWatchLoggingOptionDescriptions) {
            this.cloudWatchLoggingOptionDescriptions = CloudWatchLoggingOptionDescriptionsCopier.copy(cloudWatchLoggingOptionDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchLoggingOptionDescriptions(CloudWatchLoggingOptionDescription ... cloudWatchLoggingOptionDescriptions) {
            this.cloudWatchLoggingOptionDescriptions(Arrays.asList(cloudWatchLoggingOptionDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchLoggingOptionDescriptions(Consumer<CloudWatchLoggingOptionDescription.Builder> ... cloudWatchLoggingOptionDescriptions) {
            this.cloudWatchLoggingOptionDescriptions(Stream.of(cloudWatchLoggingOptionDescriptions).map(c -> (CloudWatchLoggingOptionDescription)((CloudWatchLoggingOptionDescription.Builder)CloudWatchLoggingOptionDescription.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCloudWatchLoggingOptionDescriptions(Collection<CloudWatchLoggingOptionDescription.BuilderImpl> cloudWatchLoggingOptionDescriptions) {
            this.cloudWatchLoggingOptionDescriptions = CloudWatchLoggingOptionDescriptionsCopier.copyFromBuilder(cloudWatchLoggingOptionDescriptions);
        }

        public final String getApplicationCode() {
            return this.applicationCode;
        }

        @Override
        public final Builder applicationCode(String applicationCode) {
            this.applicationCode = applicationCode;
            return this;
        }

        public final void setApplicationCode(String applicationCode) {
            this.applicationCode = applicationCode;
        }

        public final Long getApplicationVersionId() {
            return this.applicationVersionId;
        }

        @Override
        public final Builder applicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
            return this;
        }

        public final void setApplicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
        }

        public ApplicationDetail build() {
            return new ApplicationDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ApplicationDetail> {
        public Builder applicationName(String var1);

        public Builder applicationDescription(String var1);

        public Builder applicationARN(String var1);

        public Builder applicationStatus(String var1);

        public Builder applicationStatus(ApplicationStatus var1);

        public Builder createTimestamp(Instant var1);

        public Builder lastUpdateTimestamp(Instant var1);

        public Builder inputDescriptions(Collection<InputDescription> var1);

        public Builder inputDescriptions(InputDescription ... var1);

        public Builder inputDescriptions(Consumer<InputDescription.Builder> ... var1);

        public Builder outputDescriptions(Collection<OutputDescription> var1);

        public Builder outputDescriptions(OutputDescription ... var1);

        public Builder outputDescriptions(Consumer<OutputDescription.Builder> ... var1);

        public Builder referenceDataSourceDescriptions(Collection<ReferenceDataSourceDescription> var1);

        public Builder referenceDataSourceDescriptions(ReferenceDataSourceDescription ... var1);

        public Builder referenceDataSourceDescriptions(Consumer<ReferenceDataSourceDescription.Builder> ... var1);

        public Builder cloudWatchLoggingOptionDescriptions(Collection<CloudWatchLoggingOptionDescription> var1);

        public Builder cloudWatchLoggingOptionDescriptions(CloudWatchLoggingOptionDescription ... var1);

        public Builder cloudWatchLoggingOptionDescriptions(Consumer<CloudWatchLoggingOptionDescription.Builder> ... var1);

        public Builder applicationCode(String var1);

        public Builder applicationVersionId(Long var1);
    }
}

