/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesis.model.StopStreamEncryptionRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class StopStreamEncryptionRequestModelMarshaller {
    private static final MarshallingInfo<String> STREAMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamName").isBinary(false).build();
    private static final MarshallingInfo<String> ENCRYPTIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EncryptionType").isBinary(false).build();
    private static final MarshallingInfo<String> KEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyId").isBinary(false).build();
    private static final StopStreamEncryptionRequestModelMarshaller INSTANCE = new StopStreamEncryptionRequestModelMarshaller();

    private StopStreamEncryptionRequestModelMarshaller() {
    }

    public static StopStreamEncryptionRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StopStreamEncryptionRequest stopStreamEncryptionRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)stopStreamEncryptionRequest), (String)"stopStreamEncryptionRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)stopStreamEncryptionRequest.streamName(), STREAMNAME_BINDING);
            protocolMarshaller.marshall((Object)stopStreamEncryptionRequest.encryptionTypeAsString(), ENCRYPTIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)stopStreamEncryptionRequest.keyId(), KEYID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

