/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesis.model.PutRecordsResultEntry;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PutRecordsResultEntryMarshaller {
    private static final MarshallingInfo<String> SEQUENCENUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SequenceNumber").isBinary(false).build();
    private static final MarshallingInfo<String> SHARDID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ShardId").isBinary(false).build();
    private static final MarshallingInfo<String> ERRORCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorCode").isBinary(false).build();
    private static final MarshallingInfo<String> ERRORMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorMessage").isBinary(false).build();
    private static final PutRecordsResultEntryMarshaller INSTANCE = new PutRecordsResultEntryMarshaller();

    private PutRecordsResultEntryMarshaller() {
    }

    public static PutRecordsResultEntryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PutRecordsResultEntry putRecordsResultEntry, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)putRecordsResultEntry, (String)"putRecordsResultEntry");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)putRecordsResultEntry.sequenceNumber(), SEQUENCENUMBER_BINDING);
            protocolMarshaller.marshall((Object)putRecordsResultEntry.shardId(), SHARDID_BINDING);
            protocolMarshaller.marshall((Object)putRecordsResultEntry.errorCode(), ERRORCODE_BINDING);
            protocolMarshaller.marshall((Object)putRecordsResultEntry.errorMessage(), ERRORMESSAGE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

