/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesis.model.EnhancedMetrics;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EnhancedMetricsMarshaller {
    private static final MarshallingInfo<List> SHARDLEVELMETRICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ShardLevelMetrics").isBinary(false).build();
    private static final EnhancedMetricsMarshaller INSTANCE = new EnhancedMetricsMarshaller();

    private EnhancedMetricsMarshaller() {
    }

    public static EnhancedMetricsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EnhancedMetrics enhancedMetrics, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)enhancedMetrics, (String)"enhancedMetrics");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(enhancedMetrics.shardLevelMetricsAsStrings(), SHARDLEVELMETRICS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

