/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesis.model.EncryptionType;
import software.amazon.awssdk.services.kinesis.model.EnhancedMetrics;
import software.amazon.awssdk.services.kinesis.model.EnhancedMonitoringListCopier;
import software.amazon.awssdk.services.kinesis.model.Shard;
import software.amazon.awssdk.services.kinesis.model.ShardListCopier;
import software.amazon.awssdk.services.kinesis.model.StreamStatus;
import software.amazon.awssdk.services.kinesis.transform.StreamDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StreamDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, StreamDescription> {
    private final String streamName;
    private final String streamARN;
    private final String streamStatus;
    private final List<Shard> shards;
    private final Boolean hasMoreShards;
    private final Integer retentionPeriodHours;
    private final Instant streamCreationTimestamp;
    private final List<EnhancedMetrics> enhancedMonitoring;
    private final String encryptionType;
    private final String keyId;

    private StreamDescription(BuilderImpl builder) {
        this.streamName = builder.streamName;
        this.streamARN = builder.streamARN;
        this.streamStatus = builder.streamStatus;
        this.shards = builder.shards;
        this.hasMoreShards = builder.hasMoreShards;
        this.retentionPeriodHours = builder.retentionPeriodHours;
        this.streamCreationTimestamp = builder.streamCreationTimestamp;
        this.enhancedMonitoring = builder.enhancedMonitoring;
        this.encryptionType = builder.encryptionType;
        this.keyId = builder.keyId;
    }

    public String streamName() {
        return this.streamName;
    }

    public String streamARN() {
        return this.streamARN;
    }

    public StreamStatus streamStatus() {
        return StreamStatus.fromValue(this.streamStatus);
    }

    public String streamStatusAsString() {
        return this.streamStatus;
    }

    public List<Shard> shards() {
        return this.shards;
    }

    public Boolean hasMoreShards() {
        return this.hasMoreShards;
    }

    public Integer retentionPeriodHours() {
        return this.retentionPeriodHours;
    }

    public Instant streamCreationTimestamp() {
        return this.streamCreationTimestamp;
    }

    public List<EnhancedMetrics> enhancedMonitoring() {
        return this.enhancedMonitoring;
    }

    public EncryptionType encryptionType() {
        return EncryptionType.fromValue(this.encryptionType);
    }

    public String encryptionTypeAsString() {
        return this.encryptionType;
    }

    public String keyId() {
        return this.keyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.shards());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMoreShards());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionPeriodHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamCreationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.enhancedMonitoring());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamDescription)) {
            return false;
        }
        StreamDescription other = (StreamDescription)obj;
        return Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.streamARN(), other.streamARN()) && Objects.equals(this.streamStatusAsString(), other.streamStatusAsString()) && Objects.equals(this.shards(), other.shards()) && Objects.equals(this.hasMoreShards(), other.hasMoreShards()) && Objects.equals(this.retentionPeriodHours(), other.retentionPeriodHours()) && Objects.equals(this.streamCreationTimestamp(), other.streamCreationTimestamp()) && Objects.equals(this.enhancedMonitoring(), other.enhancedMonitoring()) && Objects.equals(this.encryptionTypeAsString(), other.encryptionTypeAsString()) && Objects.equals(this.keyId(), other.keyId());
    }

    public String toString() {
        return ToString.builder((String)"StreamDescription").add("StreamName", (Object)this.streamName()).add("StreamARN", (Object)this.streamARN()).add("StreamStatus", (Object)this.streamStatusAsString()).add("Shards", this.shards()).add("HasMoreShards", (Object)this.hasMoreShards()).add("RetentionPeriodHours", (Object)this.retentionPeriodHours()).add("StreamCreationTimestamp", (Object)this.streamCreationTimestamp()).add("EnhancedMonitoring", this.enhancedMonitoring()).add("EncryptionType", (Object)this.encryptionTypeAsString()).add("KeyId", (Object)this.keyId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.of(clazz.cast(this.streamName()));
            }
            case "StreamARN": {
                return Optional.of(clazz.cast(this.streamARN()));
            }
            case "StreamStatus": {
                return Optional.of(clazz.cast(this.streamStatusAsString()));
            }
            case "Shards": {
                return Optional.of(clazz.cast(this.shards()));
            }
            case "HasMoreShards": {
                return Optional.of(clazz.cast(this.hasMoreShards()));
            }
            case "RetentionPeriodHours": {
                return Optional.of(clazz.cast(this.retentionPeriodHours()));
            }
            case "StreamCreationTimestamp": {
                return Optional.of(clazz.cast(this.streamCreationTimestamp()));
            }
            case "EnhancedMonitoring": {
                return Optional.of(clazz.cast(this.enhancedMonitoring()));
            }
            case "EncryptionType": {
                return Optional.of(clazz.cast(this.encryptionTypeAsString()));
            }
            case "KeyId": {
                return Optional.of(clazz.cast(this.keyId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StreamDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String streamName;
        private String streamARN;
        private String streamStatus;
        private List<Shard> shards;
        private Boolean hasMoreShards;
        private Integer retentionPeriodHours;
        private Instant streamCreationTimestamp;
        private List<EnhancedMetrics> enhancedMonitoring;
        private String encryptionType;
        private String keyId;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamDescription model) {
            this.streamName(model.streamName);
            this.streamARN(model.streamARN);
            this.streamStatus(model.streamStatus);
            this.shards(model.shards);
            this.hasMoreShards(model.hasMoreShards);
            this.retentionPeriodHours(model.retentionPeriodHours);
            this.streamCreationTimestamp(model.streamCreationTimestamp);
            this.enhancedMonitoring(model.enhancedMonitoring);
            this.encryptionType(model.encryptionType);
            this.keyId(model.keyId);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final String getStreamARN() {
            return this.streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        public final String getStreamStatus() {
            return this.streamStatus;
        }

        @Override
        public final Builder streamStatus(String streamStatus) {
            this.streamStatus = streamStatus;
            return this;
        }

        @Override
        public final Builder streamStatus(StreamStatus streamStatus) {
            this.streamStatus(streamStatus.toString());
            return this;
        }

        public final void setStreamStatus(String streamStatus) {
            this.streamStatus = streamStatus;
        }

        public final Collection<Shard.Builder> getShards() {
            return this.shards != null ? (Collection)this.shards.stream().map(Shard::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder shards(Collection<Shard> shards) {
            this.shards = ShardListCopier.copy(shards);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shards(Shard ... shards) {
            this.shards(Arrays.asList(shards));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shards(Consumer<Shard.Builder> ... shards) {
            this.shards(Stream.of(shards).map(c -> (Shard)((Shard.Builder)Shard.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setShards(Collection<Shard.BuilderImpl> shards) {
            this.shards = ShardListCopier.copyFromBuilder(shards);
        }

        public final Boolean getHasMoreShards() {
            return this.hasMoreShards;
        }

        @Override
        public final Builder hasMoreShards(Boolean hasMoreShards) {
            this.hasMoreShards = hasMoreShards;
            return this;
        }

        public final void setHasMoreShards(Boolean hasMoreShards) {
            this.hasMoreShards = hasMoreShards;
        }

        public final Integer getRetentionPeriodHours() {
            return this.retentionPeriodHours;
        }

        @Override
        public final Builder retentionPeriodHours(Integer retentionPeriodHours) {
            this.retentionPeriodHours = retentionPeriodHours;
            return this;
        }

        public final void setRetentionPeriodHours(Integer retentionPeriodHours) {
            this.retentionPeriodHours = retentionPeriodHours;
        }

        public final Instant getStreamCreationTimestamp() {
            return this.streamCreationTimestamp;
        }

        @Override
        public final Builder streamCreationTimestamp(Instant streamCreationTimestamp) {
            this.streamCreationTimestamp = streamCreationTimestamp;
            return this;
        }

        public final void setStreamCreationTimestamp(Instant streamCreationTimestamp) {
            this.streamCreationTimestamp = streamCreationTimestamp;
        }

        public final Collection<EnhancedMetrics.Builder> getEnhancedMonitoring() {
            return this.enhancedMonitoring != null ? (Collection)this.enhancedMonitoring.stream().map(EnhancedMetrics::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder enhancedMonitoring(Collection<EnhancedMetrics> enhancedMonitoring) {
            this.enhancedMonitoring = EnhancedMonitoringListCopier.copy(enhancedMonitoring);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enhancedMonitoring(EnhancedMetrics ... enhancedMonitoring) {
            this.enhancedMonitoring(Arrays.asList(enhancedMonitoring));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enhancedMonitoring(Consumer<EnhancedMetrics.Builder> ... enhancedMonitoring) {
            this.enhancedMonitoring(Stream.of(enhancedMonitoring).map(c -> (EnhancedMetrics)((EnhancedMetrics.Builder)EnhancedMetrics.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEnhancedMonitoring(Collection<EnhancedMetrics.BuilderImpl> enhancedMonitoring) {
            this.enhancedMonitoring = EnhancedMonitoringListCopier.copyFromBuilder(enhancedMonitoring);
        }

        public final String getEncryptionType() {
            return this.encryptionType;
        }

        @Override
        public final Builder encryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
            return this;
        }

        @Override
        public final Builder encryptionType(EncryptionType encryptionType) {
            this.encryptionType(encryptionType.toString());
            return this;
        }

        public final void setEncryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public StreamDescription build() {
            return new StreamDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StreamDescription> {
        public Builder streamName(String var1);

        public Builder streamARN(String var1);

        public Builder streamStatus(String var1);

        public Builder streamStatus(StreamStatus var1);

        public Builder shards(Collection<Shard> var1);

        public Builder shards(Shard ... var1);

        public Builder shards(Consumer<Shard.Builder> ... var1);

        public Builder hasMoreShards(Boolean var1);

        public Builder retentionPeriodHours(Integer var1);

        public Builder streamCreationTimestamp(Instant var1);

        public Builder enhancedMonitoring(Collection<EnhancedMetrics> var1);

        public Builder enhancedMonitoring(EnhancedMetrics ... var1);

        public Builder enhancedMonitoring(Consumer<EnhancedMetrics.Builder> ... var1);

        public Builder encryptionType(String var1);

        public Builder encryptionType(EncryptionType var1);

        public Builder keyId(String var1);
    }
}

