/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.kinesis.model.KinesisRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SplitShardRequest
extends KinesisRequest
implements ToCopyableBuilder<Builder, SplitShardRequest> {
    private final String streamName;
    private final String shardToSplit;
    private final String newStartingHashKey;

    private SplitShardRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.shardToSplit = builder.shardToSplit;
        this.newStartingHashKey = builder.newStartingHashKey;
    }

    public String streamName() {
        return this.streamName;
    }

    public String shardToSplit() {
        return this.shardToSplit;
    }

    public String newStartingHashKey() {
        return this.newStartingHashKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.shardToSplit());
        hashCode = 31 * hashCode + Objects.hashCode(this.newStartingHashKey());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SplitShardRequest)) {
            return false;
        }
        SplitShardRequest other = (SplitShardRequest)((Object)obj);
        return Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.shardToSplit(), other.shardToSplit()) && Objects.equals(this.newStartingHashKey(), other.newStartingHashKey());
    }

    public String toString() {
        return ToString.builder((String)"SplitShardRequest").add("StreamName", (Object)this.streamName()).add("ShardToSplit", (Object)this.shardToSplit()).add("NewStartingHashKey", (Object)this.newStartingHashKey()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.of(clazz.cast(this.streamName()));
            }
            case "ShardToSplit": {
                return Optional.of(clazz.cast(this.shardToSplit()));
            }
            case "NewStartingHashKey": {
                return Optional.of(clazz.cast(this.newStartingHashKey()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends KinesisRequest.BuilderImpl
    implements Builder {
        private String streamName;
        private String shardToSplit;
        private String newStartingHashKey;

        private BuilderImpl() {
        }

        private BuilderImpl(SplitShardRequest model) {
            super(model);
            this.streamName(model.streamName);
            this.shardToSplit(model.shardToSplit);
            this.newStartingHashKey(model.newStartingHashKey);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final String getShardToSplit() {
            return this.shardToSplit;
        }

        @Override
        public final Builder shardToSplit(String shardToSplit) {
            this.shardToSplit = shardToSplit;
            return this;
        }

        public final void setShardToSplit(String shardToSplit) {
            this.shardToSplit = shardToSplit;
        }

        public final String getNewStartingHashKey() {
            return this.newStartingHashKey;
        }

        @Override
        public final Builder newStartingHashKey(String newStartingHashKey) {
            this.newStartingHashKey = newStartingHashKey;
            return this;
        }

        public final void setNewStartingHashKey(String newStartingHashKey) {
            this.newStartingHashKey = newStartingHashKey;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public SplitShardRequest build() {
            return new SplitShardRequest(this);
        }
    }

    public static interface Builder
    extends KinesisRequest.Builder,
    CopyableBuilder<Builder, SplitShardRequest> {
        public Builder streamName(String var1);

        public Builder shardToSplit(String var1);

        public Builder newStartingHashKey(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

