/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.kinesis.model.EncryptionType;
import software.amazon.awssdk.services.kinesis.model.KinesisResponse;
import software.amazon.awssdk.services.kinesis.model.PutRecordsResultEntry;
import software.amazon.awssdk.services.kinesis.model.PutRecordsResultEntryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutRecordsResponse
extends KinesisResponse
implements ToCopyableBuilder<Builder, PutRecordsResponse> {
    private final Integer failedRecordCount;
    private final List<PutRecordsResultEntry> records;
    private final String encryptionType;

    private PutRecordsResponse(BuilderImpl builder) {
        super(builder);
        this.failedRecordCount = builder.failedRecordCount;
        this.records = builder.records;
        this.encryptionType = builder.encryptionType;
    }

    public Integer failedRecordCount() {
        return this.failedRecordCount;
    }

    public List<PutRecordsResultEntry> records() {
        return this.records;
    }

    public EncryptionType encryptionType() {
        return EncryptionType.fromValue(this.encryptionType);
    }

    public String encryptionTypeAsString() {
        return this.encryptionType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.failedRecordCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.records());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecordsResponse)) {
            return false;
        }
        PutRecordsResponse other = (PutRecordsResponse)((Object)obj);
        return Objects.equals(this.failedRecordCount(), other.failedRecordCount()) && Objects.equals(this.records(), other.records()) && Objects.equals(this.encryptionTypeAsString(), other.encryptionTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"PutRecordsResponse").add("FailedRecordCount", (Object)this.failedRecordCount()).add("Records", this.records()).add("EncryptionType", (Object)this.encryptionTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FailedRecordCount": {
                return Optional.of(clazz.cast(this.failedRecordCount()));
            }
            case "Records": {
                return Optional.of(clazz.cast(this.records()));
            }
            case "EncryptionType": {
                return Optional.of(clazz.cast(this.encryptionTypeAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends KinesisResponse.BuilderImpl
    implements Builder {
        private Integer failedRecordCount;
        private List<PutRecordsResultEntry> records;
        private String encryptionType;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRecordsResponse model) {
            super(model);
            this.failedRecordCount(model.failedRecordCount);
            this.records(model.records);
            this.encryptionType(model.encryptionType);
        }

        public final Integer getFailedRecordCount() {
            return this.failedRecordCount;
        }

        @Override
        public final Builder failedRecordCount(Integer failedRecordCount) {
            this.failedRecordCount = failedRecordCount;
            return this;
        }

        public final void setFailedRecordCount(Integer failedRecordCount) {
            this.failedRecordCount = failedRecordCount;
        }

        public final Collection<PutRecordsResultEntry.Builder> getRecords() {
            return this.records != null ? (Collection)this.records.stream().map(PutRecordsResultEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder records(Collection<PutRecordsResultEntry> records) {
            this.records = PutRecordsResultEntryListCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(PutRecordsResultEntry ... records) {
            this.records(Arrays.asList(records));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Consumer<PutRecordsResultEntry.Builder> ... records) {
            this.records(Stream.of(records).map(c -> (PutRecordsResultEntry)((PutRecordsResultEntry.Builder)PutRecordsResultEntry.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRecords(Collection<PutRecordsResultEntry.BuilderImpl> records) {
            this.records = PutRecordsResultEntryListCopier.copyFromBuilder(records);
        }

        public final String getEncryptionType() {
            return this.encryptionType;
        }

        @Override
        public final Builder encryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
            return this;
        }

        @Override
        public final Builder encryptionType(EncryptionType encryptionType) {
            this.encryptionType(encryptionType.toString());
            return this;
        }

        public final void setEncryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
        }

        @Override
        public PutRecordsResponse build() {
            return new PutRecordsResponse(this);
        }
    }

    public static interface Builder
    extends KinesisResponse.Builder,
    CopyableBuilder<Builder, PutRecordsResponse> {
        public Builder failedRecordCount(Integer var1);

        public Builder records(Collection<PutRecordsResultEntry> var1);

        public Builder records(PutRecordsResultEntry ... var1);

        public Builder records(Consumer<PutRecordsResultEntry.Builder> ... var1);

        public Builder encryptionType(String var1);

        public Builder encryptionType(EncryptionType var1);
    }
}

