/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.model.ExtendedS3DestinationUpdate;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ExtendedS3DestinationUpdateMarshaller {
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleARN").isBinary(false).build();
    private static final MarshallingInfo<String> BUCKETARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BucketARN").isBinary(false).build();
    private static final MarshallingInfo<String> PREFIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Prefix").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> BUFFERINGHINTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BufferingHints").isBinary(false).build();
    private static final MarshallingInfo<String> COMPRESSIONFORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CompressionFormat").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ENCRYPTIONCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EncryptionConfiguration").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> CLOUDWATCHLOGGINGOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CloudWatchLoggingOptions").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> PROCESSINGCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProcessingConfiguration").isBinary(false).build();
    private static final MarshallingInfo<String> S3BACKUPMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3BackupMode").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> S3BACKUPUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3BackupUpdate").isBinary(false).build();
    private static final ExtendedS3DestinationUpdateMarshaller INSTANCE = new ExtendedS3DestinationUpdateMarshaller();

    private ExtendedS3DestinationUpdateMarshaller() {
    }

    public static ExtendedS3DestinationUpdateMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ExtendedS3DestinationUpdate extendedS3DestinationUpdate, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)extendedS3DestinationUpdate, (String)"extendedS3DestinationUpdate");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)extendedS3DestinationUpdate.roleARN(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)extendedS3DestinationUpdate.bucketARN(), BUCKETARN_BINDING);
            protocolMarshaller.marshall((Object)extendedS3DestinationUpdate.prefix(), PREFIX_BINDING);
            protocolMarshaller.marshall((Object)extendedS3DestinationUpdate.bufferingHints(), BUFFERINGHINTS_BINDING);
            protocolMarshaller.marshall((Object)extendedS3DestinationUpdate.compressionFormatAsString(), COMPRESSIONFORMAT_BINDING);
            protocolMarshaller.marshall((Object)extendedS3DestinationUpdate.encryptionConfiguration(), ENCRYPTIONCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)extendedS3DestinationUpdate.cloudWatchLoggingOptions(), CLOUDWATCHLOGGINGOPTIONS_BINDING);
            protocolMarshaller.marshall((Object)extendedS3DestinationUpdate.processingConfiguration(), PROCESSINGCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)extendedS3DestinationUpdate.s3BackupModeAsString(), S3BACKUPMODE_BINDING);
            protocolMarshaller.marshall((Object)extendedS3DestinationUpdate.s3BackupUpdate(), S3BACKUPUPDATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

