/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.model.ElasticsearchDestinationConfiguration;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ElasticsearchDestinationConfigurationMarshaller {
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleARN").isBinary(false).build();
    private static final MarshallingInfo<String> DOMAINARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DomainARN").isBinary(false).build();
    private static final MarshallingInfo<String> INDEXNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IndexName").isBinary(false).build();
    private static final MarshallingInfo<String> TYPENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TypeName").isBinary(false).build();
    private static final MarshallingInfo<String> INDEXROTATIONPERIOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IndexRotationPeriod").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> BUFFERINGHINTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BufferingHints").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> RETRYOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RetryOptions").isBinary(false).build();
    private static final MarshallingInfo<String> S3BACKUPMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3BackupMode").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> S3CONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Configuration").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> PROCESSINGCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProcessingConfiguration").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> CLOUDWATCHLOGGINGOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CloudWatchLoggingOptions").isBinary(false).build();
    private static final ElasticsearchDestinationConfigurationMarshaller INSTANCE = new ElasticsearchDestinationConfigurationMarshaller();

    private ElasticsearchDestinationConfigurationMarshaller() {
    }

    public static ElasticsearchDestinationConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ElasticsearchDestinationConfiguration elasticsearchDestinationConfiguration, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)elasticsearchDestinationConfiguration, (String)"elasticsearchDestinationConfiguration");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)elasticsearchDestinationConfiguration.roleARN(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDestinationConfiguration.domainARN(), DOMAINARN_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDestinationConfiguration.indexName(), INDEXNAME_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDestinationConfiguration.typeName(), TYPENAME_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDestinationConfiguration.indexRotationPeriodAsString(), INDEXROTATIONPERIOD_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDestinationConfiguration.bufferingHints(), BUFFERINGHINTS_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDestinationConfiguration.retryOptions(), RETRYOPTIONS_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDestinationConfiguration.s3BackupModeAsString(), S3BACKUPMODE_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDestinationConfiguration.s3Configuration(), S3CONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDestinationConfiguration.processingConfiguration(), PROCESSINGCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDestinationConfiguration.cloudWatchLoggingOptions(), CLOUDWATCHLOGGINGOPTIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

