/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.model.DeliveryStreamDescription;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DeliveryStreamDescriptionMarshaller {
    private static final MarshallingInfo<String> DELIVERYSTREAMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeliveryStreamName").isBinary(false).build();
    private static final MarshallingInfo<String> DELIVERYSTREAMARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeliveryStreamARN").isBinary(false).build();
    private static final MarshallingInfo<String> DELIVERYSTREAMSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeliveryStreamStatus").isBinary(false).build();
    private static final MarshallingInfo<String> DELIVERYSTREAMTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeliveryStreamType").isBinary(false).build();
    private static final MarshallingInfo<String> VERSIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VersionId").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATETIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreateTimestamp").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTUPDATETIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdateTimestamp").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Source").isBinary(false).build();
    private static final MarshallingInfo<List> DESTINATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Destinations").isBinary(false).build();
    private static final MarshallingInfo<Boolean> HASMOREDESTINATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HasMoreDestinations").isBinary(false).build();
    private static final DeliveryStreamDescriptionMarshaller INSTANCE = new DeliveryStreamDescriptionMarshaller();

    private DeliveryStreamDescriptionMarshaller() {
    }

    public static DeliveryStreamDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DeliveryStreamDescription deliveryStreamDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)deliveryStreamDescription, (String)"deliveryStreamDescription");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)deliveryStreamDescription.deliveryStreamName(), DELIVERYSTREAMNAME_BINDING);
            protocolMarshaller.marshall((Object)deliveryStreamDescription.deliveryStreamARN(), DELIVERYSTREAMARN_BINDING);
            protocolMarshaller.marshall((Object)deliveryStreamDescription.deliveryStreamStatusAsString(), DELIVERYSTREAMSTATUS_BINDING);
            protocolMarshaller.marshall((Object)deliveryStreamDescription.deliveryStreamTypeAsString(), DELIVERYSTREAMTYPE_BINDING);
            protocolMarshaller.marshall((Object)deliveryStreamDescription.versionId(), VERSIONID_BINDING);
            protocolMarshaller.marshall((Object)deliveryStreamDescription.createTimestamp(), CREATETIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)deliveryStreamDescription.lastUpdateTimestamp(), LASTUPDATETIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)deliveryStreamDescription.source(), SOURCE_BINDING);
            protocolMarshaller.marshall(deliveryStreamDescription.destinations(), DESTINATIONS_BINDING);
            protocolMarshaller.marshall((Object)deliveryStreamDescription.hasMoreDestinations(), HASMOREDESTINATIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

