/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.firehose.model.CloudWatchLoggingOptions;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CloudWatchLoggingOptionsMarshaller {
    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Enabled").isBinary(false).build();
    private static final MarshallingInfo<String> LOGGROUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LogGroupName").isBinary(false).build();
    private static final MarshallingInfo<String> LOGSTREAMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LogStreamName").isBinary(false).build();
    private static final CloudWatchLoggingOptionsMarshaller INSTANCE = new CloudWatchLoggingOptionsMarshaller();

    private CloudWatchLoggingOptionsMarshaller() {
    }

    public static CloudWatchLoggingOptionsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CloudWatchLoggingOptions cloudWatchLoggingOptions, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)cloudWatchLoggingOptions, (String)"cloudWatchLoggingOptions");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)cloudWatchLoggingOptions.enabled(), ENABLED_BINDING);
            protocolMarshaller.marshall((Object)cloudWatchLoggingOptions.logGroupName(), LOGGROUPNAME_BINDING);
            protocolMarshaller.marshall((Object)cloudWatchLoggingOptions.logStreamName(), LOGSTREAMNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

