/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.model.BufferingHints;
import software.amazon.awssdk.services.firehose.model.CloudWatchLoggingOptions;
import software.amazon.awssdk.services.firehose.model.CompressionFormat;
import software.amazon.awssdk.services.firehose.model.EncryptionConfiguration;
import software.amazon.awssdk.services.firehose.transform.S3DestinationDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class S3DestinationDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, S3DestinationDescription> {
    private final String roleARN;
    private final String bucketARN;
    private final String prefix;
    private final BufferingHints bufferingHints;
    private final String compressionFormat;
    private final EncryptionConfiguration encryptionConfiguration;
    private final CloudWatchLoggingOptions cloudWatchLoggingOptions;

    private S3DestinationDescription(BuilderImpl builder) {
        this.roleARN = builder.roleARN;
        this.bucketARN = builder.bucketARN;
        this.prefix = builder.prefix;
        this.bufferingHints = builder.bufferingHints;
        this.compressionFormat = builder.compressionFormat;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public String bucketARN() {
        return this.bucketARN;
    }

    public String prefix() {
        return this.prefix;
    }

    public BufferingHints bufferingHints() {
        return this.bufferingHints;
    }

    public CompressionFormat compressionFormat() {
        return CompressionFormat.fromValue(this.compressionFormat);
    }

    public String compressionFormatAsString() {
        return this.compressionFormat;
    }

    public EncryptionConfiguration encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public CloudWatchLoggingOptions cloudWatchLoggingOptions() {
        return this.cloudWatchLoggingOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.bufferingHints());
        hashCode = 31 * hashCode + Objects.hashCode(this.compressionFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLoggingOptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3DestinationDescription)) {
            return false;
        }
        S3DestinationDescription other = (S3DestinationDescription)obj;
        return Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.bucketARN(), other.bucketARN()) && Objects.equals(this.prefix(), other.prefix()) && Objects.equals(this.bufferingHints(), other.bufferingHints()) && Objects.equals(this.compressionFormatAsString(), other.compressionFormatAsString()) && Objects.equals(this.encryptionConfiguration(), other.encryptionConfiguration()) && Objects.equals(this.cloudWatchLoggingOptions(), other.cloudWatchLoggingOptions());
    }

    public String toString() {
        return ToString.builder((String)"S3DestinationDescription").add("RoleARN", (Object)this.roleARN()).add("BucketARN", (Object)this.bucketARN()).add("Prefix", (Object)this.prefix()).add("BufferingHints", (Object)this.bufferingHints()).add("CompressionFormat", (Object)this.compressionFormatAsString()).add("EncryptionConfiguration", (Object)this.encryptionConfiguration()).add("CloudWatchLoggingOptions", (Object)this.cloudWatchLoggingOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoleARN": {
                return Optional.of(clazz.cast(this.roleARN()));
            }
            case "BucketARN": {
                return Optional.of(clazz.cast(this.bucketARN()));
            }
            case "Prefix": {
                return Optional.of(clazz.cast(this.prefix()));
            }
            case "BufferingHints": {
                return Optional.of(clazz.cast(this.bufferingHints()));
            }
            case "CompressionFormat": {
                return Optional.of(clazz.cast(this.compressionFormatAsString()));
            }
            case "EncryptionConfiguration": {
                return Optional.of(clazz.cast(this.encryptionConfiguration()));
            }
            case "CloudWatchLoggingOptions": {
                return Optional.of(clazz.cast(this.cloudWatchLoggingOptions()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3DestinationDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleARN;
        private String bucketARN;
        private String prefix;
        private BufferingHints bufferingHints;
        private String compressionFormat;
        private EncryptionConfiguration encryptionConfiguration;
        private CloudWatchLoggingOptions cloudWatchLoggingOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(S3DestinationDescription model) {
            this.roleARN(model.roleARN);
            this.bucketARN(model.bucketARN);
            this.prefix(model.prefix);
            this.bufferingHints(model.bufferingHints);
            this.compressionFormat(model.compressionFormat);
            this.encryptionConfiguration(model.encryptionConfiguration);
            this.cloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final String getBucketARN() {
            return this.bucketARN;
        }

        @Override
        public final Builder bucketARN(String bucketARN) {
            this.bucketARN = bucketARN;
            return this;
        }

        public final void setBucketARN(String bucketARN) {
            this.bucketARN = bucketARN;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final BufferingHints.Builder getBufferingHints() {
            return this.bufferingHints != null ? this.bufferingHints.toBuilder() : null;
        }

        @Override
        public final Builder bufferingHints(BufferingHints bufferingHints) {
            this.bufferingHints = bufferingHints;
            return this;
        }

        public final void setBufferingHints(BufferingHints.BuilderImpl bufferingHints) {
            this.bufferingHints = bufferingHints != null ? bufferingHints.build() : null;
        }

        public final String getCompressionFormat() {
            return this.compressionFormat;
        }

        @Override
        public final Builder compressionFormat(String compressionFormat) {
            this.compressionFormat = compressionFormat;
            return this;
        }

        @Override
        public final Builder compressionFormat(CompressionFormat compressionFormat) {
            this.compressionFormat(compressionFormat.toString());
            return this;
        }

        public final void setCompressionFormat(String compressionFormat) {
            this.compressionFormat = compressionFormat;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return this.encryptionConfiguration != null ? this.encryptionConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        public final CloudWatchLoggingOptions.Builder getCloudWatchLoggingOptions() {
            return this.cloudWatchLoggingOptions != null ? this.cloudWatchLoggingOptions.toBuilder() : null;
        }

        @Override
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
            return this;
        }

        public final void setCloudWatchLoggingOptions(CloudWatchLoggingOptions.BuilderImpl cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.build() : null;
        }

        public S3DestinationDescription build() {
            return new S3DestinationDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, S3DestinationDescription> {
        public Builder roleARN(String var1);

        public Builder bucketARN(String var1);

        public Builder prefix(String var1);

        public Builder bufferingHints(BufferingHints var1);

        default public Builder bufferingHints(Consumer<BufferingHints.Builder> bufferingHints) {
            return this.bufferingHints((BufferingHints)((BufferingHints.Builder)BufferingHints.builder().apply(bufferingHints)).build());
        }

        public Builder compressionFormat(String var1);

        public Builder compressionFormat(CompressionFormat var1);

        public Builder encryptionConfiguration(EncryptionConfiguration var1);

        default public Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return this.encryptionConfiguration((EncryptionConfiguration)((EncryptionConfiguration.Builder)EncryptionConfiguration.builder().apply(encryptionConfiguration)).build());
        }

        public Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions var1);

        default public Builder cloudWatchLoggingOptions(Consumer<CloudWatchLoggingOptions.Builder> cloudWatchLoggingOptions) {
            return this.cloudWatchLoggingOptions((CloudWatchLoggingOptions)((CloudWatchLoggingOptions.Builder)CloudWatchLoggingOptions.builder().apply(cloudWatchLoggingOptions)).build());
        }
    }
}

