/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.firehose.model.FirehoseRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeDeliveryStreamRequest
extends FirehoseRequest
implements ToCopyableBuilder<Builder, DescribeDeliveryStreamRequest> {
    private final String deliveryStreamName;
    private final Integer limit;
    private final String exclusiveStartDestinationId;

    private DescribeDeliveryStreamRequest(BuilderImpl builder) {
        super(builder);
        this.deliveryStreamName = builder.deliveryStreamName;
        this.limit = builder.limit;
        this.exclusiveStartDestinationId = builder.exclusiveStartDestinationId;
    }

    public String deliveryStreamName() {
        return this.deliveryStreamName;
    }

    public Integer limit() {
        return this.limit;
    }

    public String exclusiveStartDestinationId() {
        return this.exclusiveStartDestinationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.exclusiveStartDestinationId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeliveryStreamRequest)) {
            return false;
        }
        DescribeDeliveryStreamRequest other = (DescribeDeliveryStreamRequest)((Object)obj);
        return Objects.equals(this.deliveryStreamName(), other.deliveryStreamName()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.exclusiveStartDestinationId(), other.exclusiveStartDestinationId());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDeliveryStreamRequest").add("DeliveryStreamName", (Object)this.deliveryStreamName()).add("Limit", (Object)this.limit()).add("ExclusiveStartDestinationId", (Object)this.exclusiveStartDestinationId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeliveryStreamName": {
                return Optional.of(clazz.cast(this.deliveryStreamName()));
            }
            case "Limit": {
                return Optional.of(clazz.cast(this.limit()));
            }
            case "ExclusiveStartDestinationId": {
                return Optional.of(clazz.cast(this.exclusiveStartDestinationId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends FirehoseRequest.BuilderImpl
    implements Builder {
        private String deliveryStreamName;
        private Integer limit;
        private String exclusiveStartDestinationId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeliveryStreamRequest model) {
            super(model);
            this.deliveryStreamName(model.deliveryStreamName);
            this.limit(model.limit);
            this.exclusiveStartDestinationId(model.exclusiveStartDestinationId);
        }

        public final String getDeliveryStreamName() {
            return this.deliveryStreamName;
        }

        @Override
        public final Builder deliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
            return this;
        }

        public final void setDeliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getExclusiveStartDestinationId() {
            return this.exclusiveStartDestinationId;
        }

        @Override
        public final Builder exclusiveStartDestinationId(String exclusiveStartDestinationId) {
            this.exclusiveStartDestinationId = exclusiveStartDestinationId;
            return this;
        }

        public final void setExclusiveStartDestinationId(String exclusiveStartDestinationId) {
            this.exclusiveStartDestinationId = exclusiveStartDestinationId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeDeliveryStreamRequest build() {
            return new DescribeDeliveryStreamRequest(this);
        }
    }

    public static interface Builder
    extends FirehoseRequest.Builder,
    CopyableBuilder<Builder, DescribeDeliveryStreamRequest> {
        public Builder deliveryStreamName(String var1);

        public Builder limit(Integer var1);

        public Builder exclusiveStartDestinationId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

