/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.firehose.model.DeliveryStreamType;
import software.amazon.awssdk.services.firehose.model.ElasticsearchDestinationConfiguration;
import software.amazon.awssdk.services.firehose.model.ExtendedS3DestinationConfiguration;
import software.amazon.awssdk.services.firehose.model.FirehoseRequest;
import software.amazon.awssdk.services.firehose.model.KinesisStreamSourceConfiguration;
import software.amazon.awssdk.services.firehose.model.RedshiftDestinationConfiguration;
import software.amazon.awssdk.services.firehose.model.S3DestinationConfiguration;
import software.amazon.awssdk.services.firehose.model.SplunkDestinationConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateDeliveryStreamRequest
extends FirehoseRequest
implements ToCopyableBuilder<Builder, CreateDeliveryStreamRequest> {
    private final String deliveryStreamName;
    private final String deliveryStreamType;
    private final KinesisStreamSourceConfiguration kinesisStreamSourceConfiguration;
    private final S3DestinationConfiguration s3DestinationConfiguration;
    private final ExtendedS3DestinationConfiguration extendedS3DestinationConfiguration;
    private final RedshiftDestinationConfiguration redshiftDestinationConfiguration;
    private final ElasticsearchDestinationConfiguration elasticsearchDestinationConfiguration;
    private final SplunkDestinationConfiguration splunkDestinationConfiguration;

    private CreateDeliveryStreamRequest(BuilderImpl builder) {
        super(builder);
        this.deliveryStreamName = builder.deliveryStreamName;
        this.deliveryStreamType = builder.deliveryStreamType;
        this.kinesisStreamSourceConfiguration = builder.kinesisStreamSourceConfiguration;
        this.s3DestinationConfiguration = builder.s3DestinationConfiguration;
        this.extendedS3DestinationConfiguration = builder.extendedS3DestinationConfiguration;
        this.redshiftDestinationConfiguration = builder.redshiftDestinationConfiguration;
        this.elasticsearchDestinationConfiguration = builder.elasticsearchDestinationConfiguration;
        this.splunkDestinationConfiguration = builder.splunkDestinationConfiguration;
    }

    public String deliveryStreamName() {
        return this.deliveryStreamName;
    }

    public DeliveryStreamType deliveryStreamType() {
        return DeliveryStreamType.fromValue(this.deliveryStreamType);
    }

    public String deliveryStreamTypeAsString() {
        return this.deliveryStreamType;
    }

    public KinesisStreamSourceConfiguration kinesisStreamSourceConfiguration() {
        return this.kinesisStreamSourceConfiguration;
    }

    public S3DestinationConfiguration s3DestinationConfiguration() {
        return this.s3DestinationConfiguration;
    }

    public ExtendedS3DestinationConfiguration extendedS3DestinationConfiguration() {
        return this.extendedS3DestinationConfiguration;
    }

    public RedshiftDestinationConfiguration redshiftDestinationConfiguration() {
        return this.redshiftDestinationConfiguration;
    }

    public ElasticsearchDestinationConfiguration elasticsearchDestinationConfiguration() {
        return this.elasticsearchDestinationConfiguration;
    }

    public SplunkDestinationConfiguration splunkDestinationConfiguration() {
        return this.splunkDestinationConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryStreamTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisStreamSourceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3DestinationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.extendedS3DestinationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.redshiftDestinationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticsearchDestinationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.splunkDestinationConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeliveryStreamRequest)) {
            return false;
        }
        CreateDeliveryStreamRequest other = (CreateDeliveryStreamRequest)((Object)obj);
        return Objects.equals(this.deliveryStreamName(), other.deliveryStreamName()) && Objects.equals(this.deliveryStreamTypeAsString(), other.deliveryStreamTypeAsString()) && Objects.equals(this.kinesisStreamSourceConfiguration(), other.kinesisStreamSourceConfiguration()) && Objects.equals(this.s3DestinationConfiguration(), other.s3DestinationConfiguration()) && Objects.equals(this.extendedS3DestinationConfiguration(), other.extendedS3DestinationConfiguration()) && Objects.equals(this.redshiftDestinationConfiguration(), other.redshiftDestinationConfiguration()) && Objects.equals(this.elasticsearchDestinationConfiguration(), other.elasticsearchDestinationConfiguration()) && Objects.equals(this.splunkDestinationConfiguration(), other.splunkDestinationConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"CreateDeliveryStreamRequest").add("DeliveryStreamName", (Object)this.deliveryStreamName()).add("DeliveryStreamType", (Object)this.deliveryStreamTypeAsString()).add("KinesisStreamSourceConfiguration", (Object)this.kinesisStreamSourceConfiguration()).add("S3DestinationConfiguration", (Object)this.s3DestinationConfiguration()).add("ExtendedS3DestinationConfiguration", (Object)this.extendedS3DestinationConfiguration()).add("RedshiftDestinationConfiguration", (Object)this.redshiftDestinationConfiguration()).add("ElasticsearchDestinationConfiguration", (Object)this.elasticsearchDestinationConfiguration()).add("SplunkDestinationConfiguration", (Object)this.splunkDestinationConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeliveryStreamName": {
                return Optional.of(clazz.cast(this.deliveryStreamName()));
            }
            case "DeliveryStreamType": {
                return Optional.of(clazz.cast(this.deliveryStreamTypeAsString()));
            }
            case "KinesisStreamSourceConfiguration": {
                return Optional.of(clazz.cast(this.kinesisStreamSourceConfiguration()));
            }
            case "S3DestinationConfiguration": {
                return Optional.of(clazz.cast(this.s3DestinationConfiguration()));
            }
            case "ExtendedS3DestinationConfiguration": {
                return Optional.of(clazz.cast(this.extendedS3DestinationConfiguration()));
            }
            case "RedshiftDestinationConfiguration": {
                return Optional.of(clazz.cast(this.redshiftDestinationConfiguration()));
            }
            case "ElasticsearchDestinationConfiguration": {
                return Optional.of(clazz.cast(this.elasticsearchDestinationConfiguration()));
            }
            case "SplunkDestinationConfiguration": {
                return Optional.of(clazz.cast(this.splunkDestinationConfiguration()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends FirehoseRequest.BuilderImpl
    implements Builder {
        private String deliveryStreamName;
        private String deliveryStreamType;
        private KinesisStreamSourceConfiguration kinesisStreamSourceConfiguration;
        private S3DestinationConfiguration s3DestinationConfiguration;
        private ExtendedS3DestinationConfiguration extendedS3DestinationConfiguration;
        private RedshiftDestinationConfiguration redshiftDestinationConfiguration;
        private ElasticsearchDestinationConfiguration elasticsearchDestinationConfiguration;
        private SplunkDestinationConfiguration splunkDestinationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeliveryStreamRequest model) {
            super(model);
            this.deliveryStreamName(model.deliveryStreamName);
            this.deliveryStreamType(model.deliveryStreamType);
            this.kinesisStreamSourceConfiguration(model.kinesisStreamSourceConfiguration);
            this.s3DestinationConfiguration(model.s3DestinationConfiguration);
            this.extendedS3DestinationConfiguration(model.extendedS3DestinationConfiguration);
            this.redshiftDestinationConfiguration(model.redshiftDestinationConfiguration);
            this.elasticsearchDestinationConfiguration(model.elasticsearchDestinationConfiguration);
            this.splunkDestinationConfiguration(model.splunkDestinationConfiguration);
        }

        public final String getDeliveryStreamName() {
            return this.deliveryStreamName;
        }

        @Override
        public final Builder deliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
            return this;
        }

        public final void setDeliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
        }

        public final String getDeliveryStreamType() {
            return this.deliveryStreamType;
        }

        @Override
        public final Builder deliveryStreamType(String deliveryStreamType) {
            this.deliveryStreamType = deliveryStreamType;
            return this;
        }

        @Override
        public final Builder deliveryStreamType(DeliveryStreamType deliveryStreamType) {
            this.deliveryStreamType(deliveryStreamType.toString());
            return this;
        }

        public final void setDeliveryStreamType(String deliveryStreamType) {
            this.deliveryStreamType = deliveryStreamType;
        }

        public final KinesisStreamSourceConfiguration.Builder getKinesisStreamSourceConfiguration() {
            return this.kinesisStreamSourceConfiguration != null ? this.kinesisStreamSourceConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder kinesisStreamSourceConfiguration(KinesisStreamSourceConfiguration kinesisStreamSourceConfiguration) {
            this.kinesisStreamSourceConfiguration = kinesisStreamSourceConfiguration;
            return this;
        }

        public final void setKinesisStreamSourceConfiguration(KinesisStreamSourceConfiguration.BuilderImpl kinesisStreamSourceConfiguration) {
            this.kinesisStreamSourceConfiguration = kinesisStreamSourceConfiguration != null ? kinesisStreamSourceConfiguration.build() : null;
        }

        public final S3DestinationConfiguration.Builder getS3DestinationConfiguration() {
            return this.s3DestinationConfiguration != null ? this.s3DestinationConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder s3DestinationConfiguration(S3DestinationConfiguration s3DestinationConfiguration) {
            this.s3DestinationConfiguration = s3DestinationConfiguration;
            return this;
        }

        public final void setS3DestinationConfiguration(S3DestinationConfiguration.BuilderImpl s3DestinationConfiguration) {
            this.s3DestinationConfiguration = s3DestinationConfiguration != null ? s3DestinationConfiguration.build() : null;
        }

        public final ExtendedS3DestinationConfiguration.Builder getExtendedS3DestinationConfiguration() {
            return this.extendedS3DestinationConfiguration != null ? this.extendedS3DestinationConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder extendedS3DestinationConfiguration(ExtendedS3DestinationConfiguration extendedS3DestinationConfiguration) {
            this.extendedS3DestinationConfiguration = extendedS3DestinationConfiguration;
            return this;
        }

        public final void setExtendedS3DestinationConfiguration(ExtendedS3DestinationConfiguration.BuilderImpl extendedS3DestinationConfiguration) {
            this.extendedS3DestinationConfiguration = extendedS3DestinationConfiguration != null ? extendedS3DestinationConfiguration.build() : null;
        }

        public final RedshiftDestinationConfiguration.Builder getRedshiftDestinationConfiguration() {
            return this.redshiftDestinationConfiguration != null ? this.redshiftDestinationConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder redshiftDestinationConfiguration(RedshiftDestinationConfiguration redshiftDestinationConfiguration) {
            this.redshiftDestinationConfiguration = redshiftDestinationConfiguration;
            return this;
        }

        public final void setRedshiftDestinationConfiguration(RedshiftDestinationConfiguration.BuilderImpl redshiftDestinationConfiguration) {
            this.redshiftDestinationConfiguration = redshiftDestinationConfiguration != null ? redshiftDestinationConfiguration.build() : null;
        }

        public final ElasticsearchDestinationConfiguration.Builder getElasticsearchDestinationConfiguration() {
            return this.elasticsearchDestinationConfiguration != null ? this.elasticsearchDestinationConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder elasticsearchDestinationConfiguration(ElasticsearchDestinationConfiguration elasticsearchDestinationConfiguration) {
            this.elasticsearchDestinationConfiguration = elasticsearchDestinationConfiguration;
            return this;
        }

        public final void setElasticsearchDestinationConfiguration(ElasticsearchDestinationConfiguration.BuilderImpl elasticsearchDestinationConfiguration) {
            this.elasticsearchDestinationConfiguration = elasticsearchDestinationConfiguration != null ? elasticsearchDestinationConfiguration.build() : null;
        }

        public final SplunkDestinationConfiguration.Builder getSplunkDestinationConfiguration() {
            return this.splunkDestinationConfiguration != null ? this.splunkDestinationConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder splunkDestinationConfiguration(SplunkDestinationConfiguration splunkDestinationConfiguration) {
            this.splunkDestinationConfiguration = splunkDestinationConfiguration;
            return this;
        }

        public final void setSplunkDestinationConfiguration(SplunkDestinationConfiguration.BuilderImpl splunkDestinationConfiguration) {
            this.splunkDestinationConfiguration = splunkDestinationConfiguration != null ? splunkDestinationConfiguration.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateDeliveryStreamRequest build() {
            return new CreateDeliveryStreamRequest(this);
        }
    }

    public static interface Builder
    extends FirehoseRequest.Builder,
    CopyableBuilder<Builder, CreateDeliveryStreamRequest> {
        public Builder deliveryStreamName(String var1);

        public Builder deliveryStreamType(String var1);

        public Builder deliveryStreamType(DeliveryStreamType var1);

        public Builder kinesisStreamSourceConfiguration(KinesisStreamSourceConfiguration var1);

        default public Builder kinesisStreamSourceConfiguration(Consumer<KinesisStreamSourceConfiguration.Builder> kinesisStreamSourceConfiguration) {
            return this.kinesisStreamSourceConfiguration((KinesisStreamSourceConfiguration)((KinesisStreamSourceConfiguration.Builder)KinesisStreamSourceConfiguration.builder().apply(kinesisStreamSourceConfiguration)).build());
        }

        public Builder s3DestinationConfiguration(S3DestinationConfiguration var1);

        default public Builder s3DestinationConfiguration(Consumer<S3DestinationConfiguration.Builder> s3DestinationConfiguration) {
            return this.s3DestinationConfiguration((S3DestinationConfiguration)((S3DestinationConfiguration.Builder)S3DestinationConfiguration.builder().apply(s3DestinationConfiguration)).build());
        }

        public Builder extendedS3DestinationConfiguration(ExtendedS3DestinationConfiguration var1);

        default public Builder extendedS3DestinationConfiguration(Consumer<ExtendedS3DestinationConfiguration.Builder> extendedS3DestinationConfiguration) {
            return this.extendedS3DestinationConfiguration((ExtendedS3DestinationConfiguration)((ExtendedS3DestinationConfiguration.Builder)ExtendedS3DestinationConfiguration.builder().apply(extendedS3DestinationConfiguration)).build());
        }

        public Builder redshiftDestinationConfiguration(RedshiftDestinationConfiguration var1);

        default public Builder redshiftDestinationConfiguration(Consumer<RedshiftDestinationConfiguration.Builder> redshiftDestinationConfiguration) {
            return this.redshiftDestinationConfiguration((RedshiftDestinationConfiguration)((RedshiftDestinationConfiguration.Builder)RedshiftDestinationConfiguration.builder().apply(redshiftDestinationConfiguration)).build());
        }

        public Builder elasticsearchDestinationConfiguration(ElasticsearchDestinationConfiguration var1);

        default public Builder elasticsearchDestinationConfiguration(Consumer<ElasticsearchDestinationConfiguration.Builder> elasticsearchDestinationConfiguration) {
            return this.elasticsearchDestinationConfiguration((ElasticsearchDestinationConfiguration)((ElasticsearchDestinationConfiguration.Builder)ElasticsearchDestinationConfiguration.builder().apply(elasticsearchDestinationConfiguration)).build());
        }

        public Builder splunkDestinationConfiguration(SplunkDestinationConfiguration var1);

        default public Builder splunkDestinationConfiguration(Consumer<SplunkDestinationConfiguration.Builder> splunkDestinationConfiguration) {
            return this.splunkDestinationConfiguration((SplunkDestinationConfiguration)((SplunkDestinationConfiguration.Builder)SplunkDestinationConfiguration.builder().apply(splunkDestinationConfiguration)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

