/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.S3ReferenceDataSource;
import software.amazon.awssdk.services.kinesisanalytics.model.SourceSchema;
import software.amazon.awssdk.services.kinesisanalytics.transform.ReferenceDataSourceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReferenceDataSource
implements StructuredPojo,
ToCopyableBuilder<Builder, ReferenceDataSource> {
    private final String tableName;
    private final S3ReferenceDataSource s3ReferenceDataSource;
    private final SourceSchema referenceSchema;

    private ReferenceDataSource(BuilderImpl builder) {
        this.tableName = builder.tableName;
        this.s3ReferenceDataSource = builder.s3ReferenceDataSource;
        this.referenceSchema = builder.referenceSchema;
    }

    public String tableName() {
        return this.tableName;
    }

    public S3ReferenceDataSource s3ReferenceDataSource() {
        return this.s3ReferenceDataSource;
    }

    public SourceSchema referenceSchema() {
        return this.referenceSchema;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.tableName() == null ? 0 : this.tableName().hashCode());
        hashCode = 31 * hashCode + (this.s3ReferenceDataSource() == null ? 0 : this.s3ReferenceDataSource().hashCode());
        hashCode = 31 * hashCode + (this.referenceSchema() == null ? 0 : this.referenceSchema().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferenceDataSource)) {
            return false;
        }
        ReferenceDataSource other = (ReferenceDataSource)obj;
        if (other.tableName() == null ^ this.tableName() == null) {
            return false;
        }
        if (other.tableName() != null && !other.tableName().equals(this.tableName())) {
            return false;
        }
        if (other.s3ReferenceDataSource() == null ^ this.s3ReferenceDataSource() == null) {
            return false;
        }
        if (other.s3ReferenceDataSource() != null && !other.s3ReferenceDataSource().equals(this.s3ReferenceDataSource())) {
            return false;
        }
        if (other.referenceSchema() == null ^ this.referenceSchema() == null) {
            return false;
        }
        return other.referenceSchema() == null || other.referenceSchema().equals(this.referenceSchema());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.tableName() != null) {
            sb.append("TableName: ").append(this.tableName()).append(",");
        }
        if (this.s3ReferenceDataSource() != null) {
            sb.append("S3ReferenceDataSource: ").append(this.s3ReferenceDataSource()).append(",");
        }
        if (this.referenceSchema() != null) {
            sb.append("ReferenceSchema: ").append(this.referenceSchema()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReferenceDataSourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String tableName;
        private S3ReferenceDataSource s3ReferenceDataSource;
        private SourceSchema referenceSchema;

        private BuilderImpl() {
        }

        private BuilderImpl(ReferenceDataSource model) {
            this.setTableName(model.tableName);
            this.setS3ReferenceDataSource(model.s3ReferenceDataSource);
            this.setReferenceSchema(model.referenceSchema);
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final S3ReferenceDataSource getS3ReferenceDataSource() {
            return this.s3ReferenceDataSource;
        }

        @Override
        public final Builder s3ReferenceDataSource(S3ReferenceDataSource s3ReferenceDataSource) {
            this.s3ReferenceDataSource = s3ReferenceDataSource;
            return this;
        }

        public final void setS3ReferenceDataSource(S3ReferenceDataSource s3ReferenceDataSource) {
            this.s3ReferenceDataSource = s3ReferenceDataSource;
        }

        public final SourceSchema getReferenceSchema() {
            return this.referenceSchema;
        }

        @Override
        public final Builder referenceSchema(SourceSchema referenceSchema) {
            this.referenceSchema = referenceSchema;
            return this;
        }

        public final void setReferenceSchema(SourceSchema referenceSchema) {
            this.referenceSchema = referenceSchema;
        }

        public ReferenceDataSource build() {
            return new ReferenceDataSource(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReferenceDataSource> {
        public Builder tableName(String var1);

        public Builder s3ReferenceDataSource(S3ReferenceDataSource var1);

        public Builder referenceSchema(SourceSchema var1);
    }
}

