/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.RecordColumn;
import software.amazon.awssdk.services.kinesisanalytics.model.RecordColumnsCopier;
import software.amazon.awssdk.services.kinesisanalytics.model.RecordFormat;
import software.amazon.awssdk.services.kinesisanalytics.transform.InputSchemaUpdateMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InputSchemaUpdate
implements StructuredPojo,
ToCopyableBuilder<Builder, InputSchemaUpdate> {
    private final RecordFormat recordFormatUpdate;
    private final String recordEncodingUpdate;
    private final List<RecordColumn> recordColumnUpdates;

    private InputSchemaUpdate(BuilderImpl builder) {
        this.recordFormatUpdate = builder.recordFormatUpdate;
        this.recordEncodingUpdate = builder.recordEncodingUpdate;
        this.recordColumnUpdates = builder.recordColumnUpdates;
    }

    public RecordFormat recordFormatUpdate() {
        return this.recordFormatUpdate;
    }

    public String recordEncodingUpdate() {
        return this.recordEncodingUpdate;
    }

    public List<RecordColumn> recordColumnUpdates() {
        return this.recordColumnUpdates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.recordFormatUpdate() == null ? 0 : this.recordFormatUpdate().hashCode());
        hashCode = 31 * hashCode + (this.recordEncodingUpdate() == null ? 0 : this.recordEncodingUpdate().hashCode());
        hashCode = 31 * hashCode + (this.recordColumnUpdates() == null ? 0 : this.recordColumnUpdates().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputSchemaUpdate)) {
            return false;
        }
        InputSchemaUpdate other = (InputSchemaUpdate)obj;
        if (other.recordFormatUpdate() == null ^ this.recordFormatUpdate() == null) {
            return false;
        }
        if (other.recordFormatUpdate() != null && !other.recordFormatUpdate().equals(this.recordFormatUpdate())) {
            return false;
        }
        if (other.recordEncodingUpdate() == null ^ this.recordEncodingUpdate() == null) {
            return false;
        }
        if (other.recordEncodingUpdate() != null && !other.recordEncodingUpdate().equals(this.recordEncodingUpdate())) {
            return false;
        }
        if (other.recordColumnUpdates() == null ^ this.recordColumnUpdates() == null) {
            return false;
        }
        return other.recordColumnUpdates() == null || other.recordColumnUpdates().equals(this.recordColumnUpdates());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.recordFormatUpdate() != null) {
            sb.append("RecordFormatUpdate: ").append(this.recordFormatUpdate()).append(",");
        }
        if (this.recordEncodingUpdate() != null) {
            sb.append("RecordEncodingUpdate: ").append(this.recordEncodingUpdate()).append(",");
        }
        if (this.recordColumnUpdates() != null) {
            sb.append("RecordColumnUpdates: ").append(this.recordColumnUpdates()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputSchemaUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private RecordFormat recordFormatUpdate;
        private String recordEncodingUpdate;
        private List<RecordColumn> recordColumnUpdates;

        private BuilderImpl() {
        }

        private BuilderImpl(InputSchemaUpdate model) {
            this.setRecordFormatUpdate(model.recordFormatUpdate);
            this.setRecordEncodingUpdate(model.recordEncodingUpdate);
            this.setRecordColumnUpdates(model.recordColumnUpdates);
        }

        public final RecordFormat getRecordFormatUpdate() {
            return this.recordFormatUpdate;
        }

        @Override
        public final Builder recordFormatUpdate(RecordFormat recordFormatUpdate) {
            this.recordFormatUpdate = recordFormatUpdate;
            return this;
        }

        public final void setRecordFormatUpdate(RecordFormat recordFormatUpdate) {
            this.recordFormatUpdate = recordFormatUpdate;
        }

        public final String getRecordEncodingUpdate() {
            return this.recordEncodingUpdate;
        }

        @Override
        public final Builder recordEncodingUpdate(String recordEncodingUpdate) {
            this.recordEncodingUpdate = recordEncodingUpdate;
            return this;
        }

        public final void setRecordEncodingUpdate(String recordEncodingUpdate) {
            this.recordEncodingUpdate = recordEncodingUpdate;
        }

        public final Collection<RecordColumn> getRecordColumnUpdates() {
            return this.recordColumnUpdates;
        }

        @Override
        public final Builder recordColumnUpdates(Collection<RecordColumn> recordColumnUpdates) {
            this.recordColumnUpdates = RecordColumnsCopier.copy(recordColumnUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordColumnUpdates(RecordColumn ... recordColumnUpdates) {
            if (this.recordColumnUpdates == null) {
                this.recordColumnUpdates = new ArrayList<RecordColumn>(recordColumnUpdates.length);
            }
            for (RecordColumn e : recordColumnUpdates) {
                this.recordColumnUpdates.add(e);
            }
            return this;
        }

        public final void setRecordColumnUpdates(Collection<RecordColumn> recordColumnUpdates) {
            this.recordColumnUpdates = RecordColumnsCopier.copy(recordColumnUpdates);
        }

        @SafeVarargs
        public final void setRecordColumnUpdates(RecordColumn ... recordColumnUpdates) {
            if (this.recordColumnUpdates == null) {
                this.recordColumnUpdates = new ArrayList<RecordColumn>(recordColumnUpdates.length);
            }
            for (RecordColumn e : recordColumnUpdates) {
                this.recordColumnUpdates.add(e);
            }
        }

        public InputSchemaUpdate build() {
            return new InputSchemaUpdate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InputSchemaUpdate> {
        public Builder recordFormatUpdate(RecordFormat var1);

        public Builder recordEncodingUpdate(String var1);

        public Builder recordColumnUpdates(Collection<RecordColumn> var1);

        public Builder recordColumnUpdates(RecordColumn ... var1);
    }
}

