/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus;
import software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOptionDescription;
import software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOptionDescriptionsCopier;
import software.amazon.awssdk.services.kinesisanalytics.model.InputDescription;
import software.amazon.awssdk.services.kinesisanalytics.model.InputDescriptionsCopier;
import software.amazon.awssdk.services.kinesisanalytics.model.OutputDescription;
import software.amazon.awssdk.services.kinesisanalytics.model.OutputDescriptionsCopier;
import software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSourceDescription;
import software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSourceDescriptionsCopier;
import software.amazon.awssdk.services.kinesisanalytics.transform.ApplicationDetailMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ApplicationDetail
implements StructuredPojo,
ToCopyableBuilder<Builder, ApplicationDetail> {
    private final String applicationName;
    private final String applicationDescription;
    private final String applicationARN;
    private final String applicationStatus;
    private final Date createTimestamp;
    private final Date lastUpdateTimestamp;
    private final List<InputDescription> inputDescriptions;
    private final List<OutputDescription> outputDescriptions;
    private final List<ReferenceDataSourceDescription> referenceDataSourceDescriptions;
    private final List<CloudWatchLoggingOptionDescription> cloudWatchLoggingOptionDescriptions;
    private final String applicationCode;
    private final Long applicationVersionId;

    private ApplicationDetail(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.applicationDescription = builder.applicationDescription;
        this.applicationARN = builder.applicationARN;
        this.applicationStatus = builder.applicationStatus;
        this.createTimestamp = builder.createTimestamp;
        this.lastUpdateTimestamp = builder.lastUpdateTimestamp;
        this.inputDescriptions = builder.inputDescriptions;
        this.outputDescriptions = builder.outputDescriptions;
        this.referenceDataSourceDescriptions = builder.referenceDataSourceDescriptions;
        this.cloudWatchLoggingOptionDescriptions = builder.cloudWatchLoggingOptionDescriptions;
        this.applicationCode = builder.applicationCode;
        this.applicationVersionId = builder.applicationVersionId;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String applicationDescription() {
        return this.applicationDescription;
    }

    public String applicationARN() {
        return this.applicationARN;
    }

    public String applicationStatus() {
        return this.applicationStatus;
    }

    public Date createTimestamp() {
        return this.createTimestamp;
    }

    public Date lastUpdateTimestamp() {
        return this.lastUpdateTimestamp;
    }

    public List<InputDescription> inputDescriptions() {
        return this.inputDescriptions;
    }

    public List<OutputDescription> outputDescriptions() {
        return this.outputDescriptions;
    }

    public List<ReferenceDataSourceDescription> referenceDataSourceDescriptions() {
        return this.referenceDataSourceDescriptions;
    }

    public List<CloudWatchLoggingOptionDescription> cloudWatchLoggingOptionDescriptions() {
        return this.cloudWatchLoggingOptionDescriptions;
    }

    public String applicationCode() {
        return this.applicationCode;
    }

    public Long applicationVersionId() {
        return this.applicationVersionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationName() == null ? 0 : this.applicationName().hashCode());
        hashCode = 31 * hashCode + (this.applicationDescription() == null ? 0 : this.applicationDescription().hashCode());
        hashCode = 31 * hashCode + (this.applicationARN() == null ? 0 : this.applicationARN().hashCode());
        hashCode = 31 * hashCode + (this.applicationStatus() == null ? 0 : this.applicationStatus().hashCode());
        hashCode = 31 * hashCode + (this.createTimestamp() == null ? 0 : this.createTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.lastUpdateTimestamp() == null ? 0 : this.lastUpdateTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.inputDescriptions() == null ? 0 : this.inputDescriptions().hashCode());
        hashCode = 31 * hashCode + (this.outputDescriptions() == null ? 0 : this.outputDescriptions().hashCode());
        hashCode = 31 * hashCode + (this.referenceDataSourceDescriptions() == null ? 0 : this.referenceDataSourceDescriptions().hashCode());
        hashCode = 31 * hashCode + (this.cloudWatchLoggingOptionDescriptions() == null ? 0 : this.cloudWatchLoggingOptionDescriptions().hashCode());
        hashCode = 31 * hashCode + (this.applicationCode() == null ? 0 : this.applicationCode().hashCode());
        hashCode = 31 * hashCode + (this.applicationVersionId() == null ? 0 : this.applicationVersionId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationDetail)) {
            return false;
        }
        ApplicationDetail other = (ApplicationDetail)obj;
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.applicationDescription() == null ^ this.applicationDescription() == null) {
            return false;
        }
        if (other.applicationDescription() != null && !other.applicationDescription().equals(this.applicationDescription())) {
            return false;
        }
        if (other.applicationARN() == null ^ this.applicationARN() == null) {
            return false;
        }
        if (other.applicationARN() != null && !other.applicationARN().equals(this.applicationARN())) {
            return false;
        }
        if (other.applicationStatus() == null ^ this.applicationStatus() == null) {
            return false;
        }
        if (other.applicationStatus() != null && !other.applicationStatus().equals(this.applicationStatus())) {
            return false;
        }
        if (other.createTimestamp() == null ^ this.createTimestamp() == null) {
            return false;
        }
        if (other.createTimestamp() != null && !other.createTimestamp().equals(this.createTimestamp())) {
            return false;
        }
        if (other.lastUpdateTimestamp() == null ^ this.lastUpdateTimestamp() == null) {
            return false;
        }
        if (other.lastUpdateTimestamp() != null && !other.lastUpdateTimestamp().equals(this.lastUpdateTimestamp())) {
            return false;
        }
        if (other.inputDescriptions() == null ^ this.inputDescriptions() == null) {
            return false;
        }
        if (other.inputDescriptions() != null && !other.inputDescriptions().equals(this.inputDescriptions())) {
            return false;
        }
        if (other.outputDescriptions() == null ^ this.outputDescriptions() == null) {
            return false;
        }
        if (other.outputDescriptions() != null && !other.outputDescriptions().equals(this.outputDescriptions())) {
            return false;
        }
        if (other.referenceDataSourceDescriptions() == null ^ this.referenceDataSourceDescriptions() == null) {
            return false;
        }
        if (other.referenceDataSourceDescriptions() != null && !other.referenceDataSourceDescriptions().equals(this.referenceDataSourceDescriptions())) {
            return false;
        }
        if (other.cloudWatchLoggingOptionDescriptions() == null ^ this.cloudWatchLoggingOptionDescriptions() == null) {
            return false;
        }
        if (other.cloudWatchLoggingOptionDescriptions() != null && !other.cloudWatchLoggingOptionDescriptions().equals(this.cloudWatchLoggingOptionDescriptions())) {
            return false;
        }
        if (other.applicationCode() == null ^ this.applicationCode() == null) {
            return false;
        }
        if (other.applicationCode() != null && !other.applicationCode().equals(this.applicationCode())) {
            return false;
        }
        if (other.applicationVersionId() == null ^ this.applicationVersionId() == null) {
            return false;
        }
        return other.applicationVersionId() == null || other.applicationVersionId().equals(this.applicationVersionId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.applicationDescription() != null) {
            sb.append("ApplicationDescription: ").append(this.applicationDescription()).append(",");
        }
        if (this.applicationARN() != null) {
            sb.append("ApplicationARN: ").append(this.applicationARN()).append(",");
        }
        if (this.applicationStatus() != null) {
            sb.append("ApplicationStatus: ").append(this.applicationStatus()).append(",");
        }
        if (this.createTimestamp() != null) {
            sb.append("CreateTimestamp: ").append(this.createTimestamp()).append(",");
        }
        if (this.lastUpdateTimestamp() != null) {
            sb.append("LastUpdateTimestamp: ").append(this.lastUpdateTimestamp()).append(",");
        }
        if (this.inputDescriptions() != null) {
            sb.append("InputDescriptions: ").append(this.inputDescriptions()).append(",");
        }
        if (this.outputDescriptions() != null) {
            sb.append("OutputDescriptions: ").append(this.outputDescriptions()).append(",");
        }
        if (this.referenceDataSourceDescriptions() != null) {
            sb.append("ReferenceDataSourceDescriptions: ").append(this.referenceDataSourceDescriptions()).append(",");
        }
        if (this.cloudWatchLoggingOptionDescriptions() != null) {
            sb.append("CloudWatchLoggingOptionDescriptions: ").append(this.cloudWatchLoggingOptionDescriptions()).append(",");
        }
        if (this.applicationCode() != null) {
            sb.append("ApplicationCode: ").append(this.applicationCode()).append(",");
        }
        if (this.applicationVersionId() != null) {
            sb.append("ApplicationVersionId: ").append(this.applicationVersionId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ApplicationDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private String applicationDescription;
        private String applicationARN;
        private String applicationStatus;
        private Date createTimestamp;
        private Date lastUpdateTimestamp;
        private List<InputDescription> inputDescriptions;
        private List<OutputDescription> outputDescriptions;
        private List<ReferenceDataSourceDescription> referenceDataSourceDescriptions;
        private List<CloudWatchLoggingOptionDescription> cloudWatchLoggingOptionDescriptions;
        private String applicationCode;
        private Long applicationVersionId;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationDetail model) {
            this.setApplicationName(model.applicationName);
            this.setApplicationDescription(model.applicationDescription);
            this.setApplicationARN(model.applicationARN);
            this.setApplicationStatus(model.applicationStatus);
            this.setCreateTimestamp(model.createTimestamp);
            this.setLastUpdateTimestamp(model.lastUpdateTimestamp);
            this.setInputDescriptions(model.inputDescriptions);
            this.setOutputDescriptions(model.outputDescriptions);
            this.setReferenceDataSourceDescriptions(model.referenceDataSourceDescriptions);
            this.setCloudWatchLoggingOptionDescriptions(model.cloudWatchLoggingOptionDescriptions);
            this.setApplicationCode(model.applicationCode);
            this.setApplicationVersionId(model.applicationVersionId);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getApplicationDescription() {
            return this.applicationDescription;
        }

        @Override
        public final Builder applicationDescription(String applicationDescription) {
            this.applicationDescription = applicationDescription;
            return this;
        }

        public final void setApplicationDescription(String applicationDescription) {
            this.applicationDescription = applicationDescription;
        }

        public final String getApplicationARN() {
            return this.applicationARN;
        }

        @Override
        public final Builder applicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
            return this;
        }

        public final void setApplicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
        }

        public final String getApplicationStatus() {
            return this.applicationStatus;
        }

        @Override
        public final Builder applicationStatus(String applicationStatus) {
            this.applicationStatus = applicationStatus;
            return this;
        }

        @Override
        public final Builder applicationStatus(ApplicationStatus applicationStatus) {
            this.applicationStatus(applicationStatus.toString());
            return this;
        }

        public final void setApplicationStatus(String applicationStatus) {
            this.applicationStatus = applicationStatus;
        }

        public final void setApplicationStatus(ApplicationStatus applicationStatus) {
            this.applicationStatus(applicationStatus.toString());
        }

        public final Date getCreateTimestamp() {
            return this.createTimestamp;
        }

        @Override
        public final Builder createTimestamp(Date createTimestamp) {
            this.createTimestamp = StandardMemberCopier.copy((Date)createTimestamp);
            return this;
        }

        public final void setCreateTimestamp(Date createTimestamp) {
            this.createTimestamp = StandardMemberCopier.copy((Date)createTimestamp);
        }

        public final Date getLastUpdateTimestamp() {
            return this.lastUpdateTimestamp;
        }

        @Override
        public final Builder lastUpdateTimestamp(Date lastUpdateTimestamp) {
            this.lastUpdateTimestamp = StandardMemberCopier.copy((Date)lastUpdateTimestamp);
            return this;
        }

        public final void setLastUpdateTimestamp(Date lastUpdateTimestamp) {
            this.lastUpdateTimestamp = StandardMemberCopier.copy((Date)lastUpdateTimestamp);
        }

        public final Collection<InputDescription> getInputDescriptions() {
            return this.inputDescriptions;
        }

        @Override
        public final Builder inputDescriptions(Collection<InputDescription> inputDescriptions) {
            this.inputDescriptions = InputDescriptionsCopier.copy(inputDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDescriptions(InputDescription ... inputDescriptions) {
            if (this.inputDescriptions == null) {
                this.inputDescriptions = new ArrayList<InputDescription>(inputDescriptions.length);
            }
            for (InputDescription e : inputDescriptions) {
                this.inputDescriptions.add(e);
            }
            return this;
        }

        public final void setInputDescriptions(Collection<InputDescription> inputDescriptions) {
            this.inputDescriptions = InputDescriptionsCopier.copy(inputDescriptions);
        }

        @SafeVarargs
        public final void setInputDescriptions(InputDescription ... inputDescriptions) {
            if (this.inputDescriptions == null) {
                this.inputDescriptions = new ArrayList<InputDescription>(inputDescriptions.length);
            }
            for (InputDescription e : inputDescriptions) {
                this.inputDescriptions.add(e);
            }
        }

        public final Collection<OutputDescription> getOutputDescriptions() {
            return this.outputDescriptions;
        }

        @Override
        public final Builder outputDescriptions(Collection<OutputDescription> outputDescriptions) {
            this.outputDescriptions = OutputDescriptionsCopier.copy(outputDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputDescriptions(OutputDescription ... outputDescriptions) {
            if (this.outputDescriptions == null) {
                this.outputDescriptions = new ArrayList<OutputDescription>(outputDescriptions.length);
            }
            for (OutputDescription e : outputDescriptions) {
                this.outputDescriptions.add(e);
            }
            return this;
        }

        public final void setOutputDescriptions(Collection<OutputDescription> outputDescriptions) {
            this.outputDescriptions = OutputDescriptionsCopier.copy(outputDescriptions);
        }

        @SafeVarargs
        public final void setOutputDescriptions(OutputDescription ... outputDescriptions) {
            if (this.outputDescriptions == null) {
                this.outputDescriptions = new ArrayList<OutputDescription>(outputDescriptions.length);
            }
            for (OutputDescription e : outputDescriptions) {
                this.outputDescriptions.add(e);
            }
        }

        public final Collection<ReferenceDataSourceDescription> getReferenceDataSourceDescriptions() {
            return this.referenceDataSourceDescriptions;
        }

        @Override
        public final Builder referenceDataSourceDescriptions(Collection<ReferenceDataSourceDescription> referenceDataSourceDescriptions) {
            this.referenceDataSourceDescriptions = ReferenceDataSourceDescriptionsCopier.copy(referenceDataSourceDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceDataSourceDescriptions(ReferenceDataSourceDescription ... referenceDataSourceDescriptions) {
            if (this.referenceDataSourceDescriptions == null) {
                this.referenceDataSourceDescriptions = new ArrayList<ReferenceDataSourceDescription>(referenceDataSourceDescriptions.length);
            }
            for (ReferenceDataSourceDescription e : referenceDataSourceDescriptions) {
                this.referenceDataSourceDescriptions.add(e);
            }
            return this;
        }

        public final void setReferenceDataSourceDescriptions(Collection<ReferenceDataSourceDescription> referenceDataSourceDescriptions) {
            this.referenceDataSourceDescriptions = ReferenceDataSourceDescriptionsCopier.copy(referenceDataSourceDescriptions);
        }

        @SafeVarargs
        public final void setReferenceDataSourceDescriptions(ReferenceDataSourceDescription ... referenceDataSourceDescriptions) {
            if (this.referenceDataSourceDescriptions == null) {
                this.referenceDataSourceDescriptions = new ArrayList<ReferenceDataSourceDescription>(referenceDataSourceDescriptions.length);
            }
            for (ReferenceDataSourceDescription e : referenceDataSourceDescriptions) {
                this.referenceDataSourceDescriptions.add(e);
            }
        }

        public final Collection<CloudWatchLoggingOptionDescription> getCloudWatchLoggingOptionDescriptions() {
            return this.cloudWatchLoggingOptionDescriptions;
        }

        @Override
        public final Builder cloudWatchLoggingOptionDescriptions(Collection<CloudWatchLoggingOptionDescription> cloudWatchLoggingOptionDescriptions) {
            this.cloudWatchLoggingOptionDescriptions = CloudWatchLoggingOptionDescriptionsCopier.copy(cloudWatchLoggingOptionDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchLoggingOptionDescriptions(CloudWatchLoggingOptionDescription ... cloudWatchLoggingOptionDescriptions) {
            if (this.cloudWatchLoggingOptionDescriptions == null) {
                this.cloudWatchLoggingOptionDescriptions = new ArrayList<CloudWatchLoggingOptionDescription>(cloudWatchLoggingOptionDescriptions.length);
            }
            for (CloudWatchLoggingOptionDescription e : cloudWatchLoggingOptionDescriptions) {
                this.cloudWatchLoggingOptionDescriptions.add(e);
            }
            return this;
        }

        public final void setCloudWatchLoggingOptionDescriptions(Collection<CloudWatchLoggingOptionDescription> cloudWatchLoggingOptionDescriptions) {
            this.cloudWatchLoggingOptionDescriptions = CloudWatchLoggingOptionDescriptionsCopier.copy(cloudWatchLoggingOptionDescriptions);
        }

        @SafeVarargs
        public final void setCloudWatchLoggingOptionDescriptions(CloudWatchLoggingOptionDescription ... cloudWatchLoggingOptionDescriptions) {
            if (this.cloudWatchLoggingOptionDescriptions == null) {
                this.cloudWatchLoggingOptionDescriptions = new ArrayList<CloudWatchLoggingOptionDescription>(cloudWatchLoggingOptionDescriptions.length);
            }
            for (CloudWatchLoggingOptionDescription e : cloudWatchLoggingOptionDescriptions) {
                this.cloudWatchLoggingOptionDescriptions.add(e);
            }
        }

        public final String getApplicationCode() {
            return this.applicationCode;
        }

        @Override
        public final Builder applicationCode(String applicationCode) {
            this.applicationCode = applicationCode;
            return this;
        }

        public final void setApplicationCode(String applicationCode) {
            this.applicationCode = applicationCode;
        }

        public final Long getApplicationVersionId() {
            return this.applicationVersionId;
        }

        @Override
        public final Builder applicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
            return this;
        }

        public final void setApplicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
        }

        public ApplicationDetail build() {
            return new ApplicationDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ApplicationDetail> {
        public Builder applicationName(String var1);

        public Builder applicationDescription(String var1);

        public Builder applicationARN(String var1);

        public Builder applicationStatus(String var1);

        public Builder applicationStatus(ApplicationStatus var1);

        public Builder createTimestamp(Date var1);

        public Builder lastUpdateTimestamp(Date var1);

        public Builder inputDescriptions(Collection<InputDescription> var1);

        public Builder inputDescriptions(InputDescription ... var1);

        public Builder outputDescriptions(Collection<OutputDescription> var1);

        public Builder outputDescriptions(OutputDescription ... var1);

        public Builder referenceDataSourceDescriptions(Collection<ReferenceDataSourceDescription> var1);

        public Builder referenceDataSourceDescriptions(ReferenceDataSourceDescription ... var1);

        public Builder cloudWatchLoggingOptionDescriptions(Collection<CloudWatchLoggingOptionDescription> var1);

        public Builder cloudWatchLoggingOptionDescriptions(CloudWatchLoggingOptionDescription ... var1);

        public Builder applicationCode(String var1);

        public Builder applicationVersionId(Long var1);
    }
}

