/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesis.model.SequenceNumberRange;

@SdkInternalApi
public class SequenceNumberRangeMarshaller {
    private static final MarshallingInfo<String> STARTINGSEQUENCENUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartingSequenceNumber").build();
    private static final MarshallingInfo<String> ENDINGSEQUENCENUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndingSequenceNumber").build();
    private static final SequenceNumberRangeMarshaller instance = new SequenceNumberRangeMarshaller();

    public static SequenceNumberRangeMarshaller getInstance() {
        return instance;
    }

    public void marshall(SequenceNumberRange sequenceNumberRange, ProtocolMarshaller protocolMarshaller) {
        if (sequenceNumberRange == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)sequenceNumberRange.startingSequenceNumber(), STARTINGSEQUENCENUMBER_BINDING);
            protocolMarshaller.marshall((Object)sequenceNumberRange.endingSequenceNumber(), ENDINGSEQUENCENUMBER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

