/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.nio.ByteBuffer;
import java.util.Date;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.kinesis.model.Record;

public class RecordUnmarshaller
implements Unmarshaller<Record, JsonUnmarshallerContext> {
    private static RecordUnmarshaller INSTANCE;

    public Record unmarshall(JsonUnmarshallerContext context) throws Exception {
        Record.Builder recordBuilder = Record.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("SequenceNumber", targetDepth)) {
                    context.nextToken();
                    recordBuilder.sequenceNumber((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ApproximateArrivalTimestamp", targetDepth)) {
                    context.nextToken();
                    recordBuilder.approximateArrivalTimestamp((Date)context.getUnmarshaller(Date.class).unmarshall((Object)context));
                }
                if (context.testExpression("Data", targetDepth)) {
                    context.nextToken();
                    recordBuilder.data((ByteBuffer)context.getUnmarshaller(ByteBuffer.class).unmarshall((Object)context));
                }
                if (context.testExpression("PartitionKey", targetDepth)) {
                    context.nextToken();
                    recordBuilder.partitionKey((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Record)recordBuilder.build();
    }

    public static RecordUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RecordUnmarshaller();
        }
        return INSTANCE;
    }
}

