/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.kinesis.model.PutRecordsRequestEntry;
import software.amazon.awssdk.services.kinesis.model.PutRecordsRequestEntryListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutRecordsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PutRecordsRequest> {
    private final List<PutRecordsRequestEntry> records;
    private final String streamName;

    private PutRecordsRequest(BuilderImpl builder) {
        this.records = builder.records;
        this.streamName = builder.streamName;
    }

    public List<PutRecordsRequestEntry> records() {
        return this.records;
    }

    public String streamName() {
        return this.streamName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.records() == null ? 0 : this.records().hashCode());
        hashCode = 31 * hashCode + (this.streamName() == null ? 0 : this.streamName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecordsRequest)) {
            return false;
        }
        PutRecordsRequest other = (PutRecordsRequest)((Object)obj);
        if (other.records() == null ^ this.records() == null) {
            return false;
        }
        if (other.records() != null && !other.records().equals(this.records())) {
            return false;
        }
        if (other.streamName() == null ^ this.streamName() == null) {
            return false;
        }
        return other.streamName() == null || other.streamName().equals(this.streamName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.records() != null) {
            sb.append("Records: ").append(this.records()).append(",");
        }
        if (this.streamName() != null) {
            sb.append("StreamName: ").append(this.streamName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<PutRecordsRequestEntry> records = new SdkInternalList();
        private String streamName;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRecordsRequest model) {
            this.setRecords(model.records);
            this.setStreamName(model.streamName);
        }

        public final Collection<PutRecordsRequestEntry> getRecords() {
            return this.records;
        }

        @Override
        public final Builder records(Collection<PutRecordsRequestEntry> records) {
            this.records = PutRecordsRequestEntryListCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(PutRecordsRequestEntry ... records) {
            if (this.records == null) {
                this.records = new SdkInternalList(records.length);
            }
            for (PutRecordsRequestEntry e : records) {
                this.records.add(e);
            }
            return this;
        }

        public final void setRecords(Collection<PutRecordsRequestEntry> records) {
            this.records = PutRecordsRequestEntryListCopier.copy(records);
        }

        @SafeVarargs
        public final void setRecords(PutRecordsRequestEntry ... records) {
            if (this.records == null) {
                this.records = new SdkInternalList(records.length);
            }
            for (PutRecordsRequestEntry e : records) {
                this.records.add(e);
            }
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public PutRecordsRequest build() {
            return new PutRecordsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutRecordsRequest> {
        public Builder records(Collection<PutRecordsRequestEntry> var1);

        public Builder records(PutRecordsRequestEntry ... var1);

        public Builder streamName(String var1);
    }
}

