/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.nio.ByteBuffer;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutRecordRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PutRecordRequest> {
    private final String streamName;
    private final ByteBuffer data;
    private final String partitionKey;
    private final String explicitHashKey;
    private final String sequenceNumberForOrdering;

    private PutRecordRequest(BuilderImpl builder) {
        this.streamName = builder.streamName;
        this.data = builder.data;
        this.partitionKey = builder.partitionKey;
        this.explicitHashKey = builder.explicitHashKey;
        this.sequenceNumberForOrdering = builder.sequenceNumberForOrdering;
    }

    public String streamName() {
        return this.streamName;
    }

    public ByteBuffer data() {
        return this.data;
    }

    public String partitionKey() {
        return this.partitionKey;
    }

    public String explicitHashKey() {
        return this.explicitHashKey;
    }

    public String sequenceNumberForOrdering() {
        return this.sequenceNumberForOrdering;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.streamName() == null ? 0 : this.streamName().hashCode());
        hashCode = 31 * hashCode + (this.data() == null ? 0 : this.data().hashCode());
        hashCode = 31 * hashCode + (this.partitionKey() == null ? 0 : this.partitionKey().hashCode());
        hashCode = 31 * hashCode + (this.explicitHashKey() == null ? 0 : this.explicitHashKey().hashCode());
        hashCode = 31 * hashCode + (this.sequenceNumberForOrdering() == null ? 0 : this.sequenceNumberForOrdering().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecordRequest)) {
            return false;
        }
        PutRecordRequest other = (PutRecordRequest)((Object)obj);
        if (other.streamName() == null ^ this.streamName() == null) {
            return false;
        }
        if (other.streamName() != null && !other.streamName().equals(this.streamName())) {
            return false;
        }
        if (other.data() == null ^ this.data() == null) {
            return false;
        }
        if (other.data() != null && !other.data().equals(this.data())) {
            return false;
        }
        if (other.partitionKey() == null ^ this.partitionKey() == null) {
            return false;
        }
        if (other.partitionKey() != null && !other.partitionKey().equals(this.partitionKey())) {
            return false;
        }
        if (other.explicitHashKey() == null ^ this.explicitHashKey() == null) {
            return false;
        }
        if (other.explicitHashKey() != null && !other.explicitHashKey().equals(this.explicitHashKey())) {
            return false;
        }
        if (other.sequenceNumberForOrdering() == null ^ this.sequenceNumberForOrdering() == null) {
            return false;
        }
        return other.sequenceNumberForOrdering() == null || other.sequenceNumberForOrdering().equals(this.sequenceNumberForOrdering());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.streamName() != null) {
            sb.append("StreamName: ").append(this.streamName()).append(",");
        }
        if (this.data() != null) {
            sb.append("Data: ").append(this.data()).append(",");
        }
        if (this.partitionKey() != null) {
            sb.append("PartitionKey: ").append(this.partitionKey()).append(",");
        }
        if (this.explicitHashKey() != null) {
            sb.append("ExplicitHashKey: ").append(this.explicitHashKey()).append(",");
        }
        if (this.sequenceNumberForOrdering() != null) {
            sb.append("SequenceNumberForOrdering: ").append(this.sequenceNumberForOrdering()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String streamName;
        private ByteBuffer data;
        private String partitionKey;
        private String explicitHashKey;
        private String sequenceNumberForOrdering;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRecordRequest model) {
            this.setStreamName(model.streamName);
            this.setData(model.data);
            this.setPartitionKey(model.partitionKey);
            this.setExplicitHashKey(model.explicitHashKey);
            this.setSequenceNumberForOrdering(model.sequenceNumberForOrdering);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final ByteBuffer getData() {
            return this.data;
        }

        @Override
        public final Builder data(ByteBuffer data) {
            this.data = StandardMemberCopier.copy((ByteBuffer)data);
            return this;
        }

        public final void setData(ByteBuffer data) {
            this.data = StandardMemberCopier.copy((ByteBuffer)data);
        }

        public final String getPartitionKey() {
            return this.partitionKey;
        }

        @Override
        public final Builder partitionKey(String partitionKey) {
            this.partitionKey = partitionKey;
            return this;
        }

        public final void setPartitionKey(String partitionKey) {
            this.partitionKey = partitionKey;
        }

        public final String getExplicitHashKey() {
            return this.explicitHashKey;
        }

        @Override
        public final Builder explicitHashKey(String explicitHashKey) {
            this.explicitHashKey = explicitHashKey;
            return this;
        }

        public final void setExplicitHashKey(String explicitHashKey) {
            this.explicitHashKey = explicitHashKey;
        }

        public final String getSequenceNumberForOrdering() {
            return this.sequenceNumberForOrdering;
        }

        @Override
        public final Builder sequenceNumberForOrdering(String sequenceNumberForOrdering) {
            this.sequenceNumberForOrdering = sequenceNumberForOrdering;
            return this;
        }

        public final void setSequenceNumberForOrdering(String sequenceNumberForOrdering) {
            this.sequenceNumberForOrdering = sequenceNumberForOrdering;
        }

        public PutRecordRequest build() {
            return new PutRecordRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutRecordRequest> {
        public Builder streamName(String var1);

        public Builder data(ByteBuffer var1);

        public Builder partitionKey(String var1);

        public Builder explicitHashKey(String var1);

        public Builder sequenceNumberForOrdering(String var1);
    }
}

